/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

public class ModClusterLogger_$logger
extends DelegatingBasicLogger
implements ModClusterLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ModClusterLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ModClusterLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void errorAddingMetrics(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorAddingMetrics$str(), new Object[0]);
    }

    protected String errorAddingMetrics$str() {
        return "WFLYMODCLS0001: Error adding metrics.";
    }

    @Override
    public final void multicastInterfaceNotAvailable() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.multicastInterfaceNotAvailable$str(), new Object[0]);
    }

    protected String multicastInterfaceNotAvailable$str() {
        return "WFLYMODCLS0004: Mod_cluster requires Advertise but Multicast interface is not available.";
    }

    @Override
    public final void usingSimpleLoadProvider(String proxyName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingSimpleLoadProvider$str(), (Object)proxyName);
    }

    protected String usingSimpleLoadProvider$str() {
        return "WFLYMODCLS0005: No mod_cluster load balance factor provider specified for proxy '%s'! Using load balance factor provider with constant factor of '1'.";
    }

    @Override
    public final void errorApplyingMetricProperties(Throwable cause, String metricClass) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorApplyingMetricProperties$str(), (Object)metricClass);
    }

    protected String errorApplyingMetricProperties$str() {
        return "WFLYMODCLS0006: Error applying properties to load metric class '%s'. Metric will not be loaded.";
    }

    protected String contextOrHostNotFound$str() {
        return "WFLYMODCLS0011: Virtual host '%s' or context '%s' not found.";
    }

    @Override
    public final String contextOrHostNotFound(String host, String context) {
        return String.format(this.getLoggingLocale(), this.contextOrHostNotFound$str(), host, context);
    }

    protected String excludedContextsWrongFormat$str() {
        return "WFLYMODCLS0019: '%s' is not a valid value for excluded-contexts.";
    }

    @Override
    public final IllegalArgumentException excludedContextsWrongFormat(String trimmedContexts) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.excludedContextsWrongFormat$str(), trimmedContexts));
        ModClusterLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void excludedContextsUseSlashInsteadROOT() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.excludedContextsUseSlashInsteadROOT$str(), new Object[0]);
    }

    protected String excludedContextsUseSlashInsteadROOT$str() {
        return "WFLYMODCLS0021: Value 'ROOT' for excluded-contexts is deprecated, to exclude the root context use '/' instead.";
    }

    @Override
    public final void errorLoadingModuleForCustomMetric(String moduleName, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorLoadingModuleForCustomMetric$str(), (Object)moduleName);
    }

    protected String errorLoadingModuleForCustomMetric$str() {
        return "WFLYMODCLS0023: Error loading module '%s' to load custom metric from.";
    }

    @Override
    public final void ignoredElement(String element) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoredElement$str(), (Object)element);
    }

    protected String ignoredElement$str() {
        return "WFLYMODCLS0025: The '%s' element is no longer supported and will be ignored.";
    }

    @Override
    public final void ignoredAttribute(String attribute, String element) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoredAttribute$str(), (Object)attribute, (Object)element);
    }

    protected String ignoredAttribute$str() {
        return "WFLYMODCLS0026: Attribute '%s' of element '%s' is no longer supported and will be ignored.";
    }
}

