/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.lang.invoke.MethodHandles;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYMODCLS", length=4)
interface ModClusterLogger
extends BasicLogger {
    public static final ModClusterLogger ROOT_LOGGER = (ModClusterLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), ModClusterLogger.class, (String)"org.wildfly.extension.mod_cluster");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Error adding metrics.")
    public void errorAddingMetrics(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Mod_cluster requires Advertise but Multicast interface is not available.")
    public void multicastInterfaceNotAvailable();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="No mod_cluster load balance factor provider specified for proxy '%s'! Using load balance factor provider with constant factor of '1'.")
    public void usingSimpleLoadProvider(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Error applying properties to load metric class '%s'. Metric will not be loaded.")
    public void errorApplyingMetricProperties(@Cause Throwable var1, String var2);

    @Message(id=11, value="Virtual host '%s' or context '%s' not found.")
    public String contextOrHostNotFound(String var1, String var2);

    @Message(id=19, value="'%s' is not a valid value for excluded-contexts.")
    public IllegalArgumentException excludedContextsWrongFormat(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="Value 'ROOT' for excluded-contexts is deprecated, to exclude the root context use '/' instead.")
    public void excludedContextsUseSlashInsteadROOT();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=23, value="Error loading module '%s' to load custom metric from.")
    public void errorLoadingModuleForCustomMetric(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25, value="The '%s' element is no longer supported and will be ignored.")
    public void ignoredElement(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=26, value="Attribute '%s' of element '%s' is no longer supported and will be ignored.")
    public void ignoredAttribute(String var1, String var2);
}

