/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.NamingCloseable;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.xnio.FutureResult;
import org.xnio.IoFuture;

public final class RemoteNamingProvider
implements NamingProvider {
    private final Endpoint endpoint;
    private final Supplier<IoFuture<Connection>> connectionFactory;
    private final NamingCloseable closeable;
    private final URI providerUri;
    private final AuthenticationConfiguration authenticationConfiguration;

    RemoteNamingProvider(Endpoint endpoint, URI providerUri, AuthenticationConfiguration connectionConfiguration, AuthenticationConfiguration operateConfiguration, SSLContext sslContext, FastHashtable<String, Object> env) {
        this.endpoint = endpoint;
        this.providerUri = providerUri;
        this.connectionFactory = () -> endpoint.getConnection(providerUri, sslContext, connectionConfiguration, operateConfiguration);
        this.closeable = NamingCloseable.NULL;
        this.authenticationConfiguration = operateConfiguration;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ConnectionPeerIdentity getPeerIdentityForNaming() throws NamingException {
        try {
            return this.getPeerIdentity();
        }
        catch (IOException e) {
            throw Messages.log.connectFailed(e);
        }
        catch (AuthenticationException e) {
            throw Messages.log.authenticationFailed(e);
        }
    }

    public ConnectionPeerIdentity getPeerIdentity() throws AuthenticationException, IOException {
        Connection connection = (Connection)AccessController.doPrivileged(this.connectionFactory::get).get();
        if (connection.supportsRemoteAuth()) {
            return connection.getPeerIdentityContext().authenticate(this.authenticationConfiguration);
        }
        return connection.getConnectionPeerIdentity();
    }

    public IoFuture<ConnectionPeerIdentity> getFuturePeerIdentity() {
        FutureResult futureResult = new FutureResult();
        AccessController.doPrivileged(this.connectionFactory::get).addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, FutureResult<ConnectionPeerIdentity>>(){

            public void handleCancelled(FutureResult<ConnectionPeerIdentity> attachment) {
                attachment.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<ConnectionPeerIdentity> attachment) {
                attachment.setException(exception);
            }

            public void handleDone(Connection data, FutureResult<ConnectionPeerIdentity> attachment) {
                try {
                    if (data.supportsRemoteAuth()) {
                        attachment.setResult((Object)data.getPeerIdentityContext().authenticate(RemoteNamingProvider.this.authenticationConfiguration));
                    } else {
                        attachment.setResult((Object)data.getConnectionPeerIdentity());
                    }
                }
                catch (AuthenticationException e) {
                    attachment.setException((IOException)new javax.security.sasl.AuthenticationException(e.getMessage(), e));
                }
            }
        }, (Object)futureResult);
        return futureResult.getIoFuture();
    }

    @Override
    public URI getProviderUri() {
        return this.providerUri;
    }

    @Override
    public void close() throws NamingException {
        this.closeable.close();
    }
}

