/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.AbstractFederatingContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteClientTransport;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.store.RelativeFederatingContext;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class RemoteContext
extends AbstractFederatingContext {
    private final RemoteNamingProvider provider;
    private final String scheme;

    RemoteContext(RemoteNamingProvider provider, String scheme, Hashtable<String, Object> env) throws CommunicationException {
        super(FastHashtable.of(env));
        this.provider = provider;
        this.scheme = scheme;
    }

    RemoteClientTransport getRemoteTransport() throws NamingException {
        Endpoint endpoint = Endpoint.getCurrent();
        if (endpoint == null) {
            throw Messages.log.noRemotingEndpoint();
        }
        try {
            Connection connection = this.provider.getConnection();
            IoFuture future = RemoteClientTransport.SERVICE_HANDLE.getClientService(connection, OptionMap.EMPTY);
            try {
                return (RemoteClientTransport)future.getInterruptibly();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                future.cancel();
                throw Messages.log.operationInterrupted();
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof NamingException) {
                throw (NamingException)e.getCause();
            }
            throw Messages.log.connectFailed(e);
        }
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RemoteContext(this.provider, this.scheme, this.getEnvironment());
        }
        return this.getRemoteTransport().lookup(this, name, false);
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RemoteContext(this.provider, this.scheme, this.getEnvironment());
        }
        return this.getRemoteTransport().lookup(this, name, true);
    }

    @Override
    protected void bindNative(Name name, Object obj) throws NamingException {
        this.getRemoteTransport().bind(name, obj, false);
    }

    @Override
    protected void rebindNative(Name name, Object obj) throws NamingException {
        this.getRemoteTransport().bind(name, obj, true);
    }

    @Override
    protected void unbindNative(Name name) throws NamingException {
        this.getRemoteTransport().unbind(name);
    }

    @Override
    protected void renameNative(Name oldName, Name newName) throws NamingException {
        this.getRemoteTransport().rename(oldName, newName);
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        return this.getRemoteTransport().list(name);
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        return this.getRemoteTransport().listBindings(name, this);
    }

    @Override
    protected void destroySubcontextNative(Name name) throws NamingException {
        this.getRemoteTransport().destroySubcontext(name);
    }

    @Override
    protected Context createSubcontextNative(Name name) throws NamingException {
        CompositeName compositeName = NamingUtils.toCompositeName(name);
        this.getRemoteTransport().createSubcontext(compositeName);
        return new RelativeFederatingContext((FastHashtable<String, Object>)this.getEnvironment(), this, compositeName);
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        String scheme = this.scheme;
        return scheme == null || scheme.isEmpty() ? "" : scheme + ":";
    }
}

