/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.OptionMap;

public final class RemoteNamingProviderFactory
implements NamingProviderFactory {
    public static final String USE_SEPARATE_CONNECTION = "org.wildfly.naming.client.remote.use-separate-connection";
    static final Attachments.Key<RemoteNamingProvider> PROVIDER_KEY = new Attachments.Key(RemoteNamingProvider.class);
    private static final Attachments.Key<ProviderMap> PROVIDER_MAP_KEY = new Attachments.Key(ProviderMap.class);

    @Override
    public boolean supportsUriScheme(String providerScheme) {
        Endpoint endpoint = Endpoint.getCurrent();
        return endpoint != null && endpoint.isValidUriScheme(providerScheme);
    }

    @Override
    public NamingProvider createProvider(URI providerUri, FastHashtable<String, Object> env) throws NamingException {
        RemoteNamingProvider appearing;
        URIKey key;
        RemoteNamingProvider provider;
        ProviderMap appearing2;
        Endpoint endpoint = Endpoint.getCurrent();
        boolean useSeparateConnection = Boolean.parseBoolean(String.valueOf(env.get(USE_SEPARATE_CONNECTION)));
        AuthenticationContext context = AuthenticationContext.captureCurrent();
        if (useSeparateConnection) {
            Connection connection;
            try {
                connection = (Connection)endpoint.connect(providerUri, OptionMap.EMPTY, context).get();
            }
            catch (IOException e) {
                throw Messages.log.connectFailed(e);
            }
            RemoteNamingProvider provider2 = new RemoteNamingProvider(connection, context, env);
            connection.getAttachments().attach(PROVIDER_KEY, (Object)provider2);
            return provider2;
        }
        Attachments attachments = endpoint.getAttachments();
        ProviderMap map = (ProviderMap)attachments.getAttachment(PROVIDER_MAP_KEY);
        if (map == null && (appearing2 = (ProviderMap)attachments.attachIfAbsent(PROVIDER_MAP_KEY, (Object)(map = new ProviderMap()))) != null) {
            map = appearing2;
        }
        if ((provider = (RemoteNamingProvider)map.get(key = new URIKey(providerUri.getScheme(), providerUri.getUserInfo(), providerUri.getHost(), providerUri.getPort()))) == null && (appearing = map.putIfAbsent(key, provider = new RemoteNamingProvider(endpoint, providerUri, context, env))) != null) {
            provider = appearing;
        }
        return provider;
    }

    static final class ProviderMap
    extends ConcurrentHashMap<URIKey, RemoteNamingProvider> {
        ProviderMap() {
        }
    }

    static final class URIKey {
        private final String scheme;
        private final String userInfo;
        private final String host;
        private final int port;
        private final int hashCode;

        URIKey(String scheme, String userInfo, String host, int port) {
            this.scheme = scheme == null ? "" : scheme;
            this.userInfo = userInfo == null ? "" : userInfo;
            this.host = host == null ? "" : host;
            this.port = port;
            this.hashCode = port + 31 * (this.host.hashCode() + 31 * (this.userInfo.hashCode() + 31 * this.scheme.hashCode()));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof URIKey && this.equals((URIKey)o);
        }

        private boolean equals(URIKey key) {
            return this.hashCode == key.hashCode && this.port == key.port && this.scheme.equals(key.scheme) && this.userInfo.equals(key.userInfo) && this.host.equals(key.host);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

