/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.function.IntUnaryOperator;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.ClientServiceHandle;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.util.BlockingInvocation;
import org.jboss.remoting3.util.Invocation;
import org.jboss.remoting3.util.InvocationTracker;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteContext;
import org.wildfly.naming.client.store.RelativeFederatingContext;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;
import org.xnio.Cancellable;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

final class RemoteClientTransport {
    static final ClientServiceHandle<RemoteClientTransport> SERVICE_HANDLE = new ClientServiceHandle("naming", RemoteClientTransport::construct);
    private final MarshallingConfiguration configuration;
    private final InvocationTracker tracker;
    private final Channel channel;
    private final int version;
    private static final byte[] initialBytes = new byte[]{110, 97, 109, 105, 110, 103};

    RemoteClientTransport(Channel channel, int version, MarshallingConfiguration configuration) {
        configuration.setClassResolver((ClassResolver)new ContextClassResolver());
        this.channel = channel;
        this.configuration = configuration;
        this.version = version;
        this.tracker = new InvocationTracker(channel, version == 1 ? IntUnaryOperator.identity() : RemoteClientTransport::defaultFunction);
    }

    private static int defaultFunction(int random) {
        return random & 0xFFFF;
    }

    private static IoFuture<RemoteClientTransport> construct(final Channel channel) {
        final FutureResult futureResult = new FutureResult((Executor)channel.getConnection().getEndpoint().getXnioWorker());
        channel.receiveMessage(new Channel.Receiver(){

            public void handleError(Channel channel, IOException error) {
                futureResult.setException(error);
            }

            public void handleEnd(Channel channel) {
                futureResult.setCancelled();
            }

            public void handleMessage(Channel channel, MessageInputStream message) {
                try (MessageInputStream mis = message;){
                    int version;
                    byte[] namingHeader = new byte[initialBytes.length];
                    mis.read(namingHeader);
                    if (!Arrays.equals(namingHeader, initialBytes)) {
                        futureResult.setException(new IOException(Messages.log.invalidHeader()));
                        return;
                    }
                    int length = mis.readUnsignedByte();
                    boolean hasOne = false;
                    boolean hasTwo = false;
                    for (int i = 0; i < length; ++i) {
                        int v = mis.readUnsignedByte();
                        if (v == 1) {
                            hasOne = true;
                            continue;
                        }
                        if (v != 2) continue;
                        hasTwo = true;
                    }
                    if (hasTwo) {
                        version = 2;
                    } else if (hasOne) {
                        version = 1;
                    } else {
                        futureResult.setException(new IOException(Messages.log.noCompatibleVersions()));
                        return;
                    }
                    MarshallingConfiguration configuration = new MarshallingConfiguration();
                    configuration.setVersion(version == 2 ? 4 : 2);
                    RemoteClientTransport remoteClientTransport = new RemoteClientTransport(channel, version, configuration);
                    try (MessageOutputStream os = remoteClientTransport.tracker.allocateMessage();){
                        os.write(initialBytes);
                        os.writeByte(version);
                    }
                    remoteClientTransport.start();
                    futureResult.setResult((Object)remoteClientTransport);
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)channel);
                    futureResult.setException(new IOException(Messages.log.connectFailed(e)));
                    return;
                }
            }
        });
        futureResult.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                if (futureResult.setCancelled()) {
                    IoUtils.safeClose((Closeable)channel);
                }
                return this;
            }
        });
        return futureResult.getIoFuture();
    }

    void start() {
        this.channel.receiveMessage(new Channel.Receiver(){

            public void handleError(Channel channel, IOException error) {
                IoUtils.safeClose((Closeable)channel);
            }

            public void handleEnd(Channel channel) {
                IoUtils.safeClose((Closeable)channel);
            }

            public void handleMessage(Channel channel, MessageInputStream message) {
                try {
                    int messageId = message.readUnsignedByte();
                    int id = RemoteClientTransport.this.readId(message);
                    int result = message.readUnsignedByte();
                    if (result != 0 && result != 1) {
                        throw Messages.log.outcomeNotUnderstood();
                    }
                    RemoteClientTransport.this.tracker.signalResponse(id, messageId, message, true);
                    channel.receiveMessage((Channel.Receiver)this);
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)channel);
                    IoUtils.safeClose((Closeable)message);
                }
            }
        });
    }

    int readId(MessageInputStream stream) throws IOException {
        return this.version == 1 ? stream.readInt() : stream.readUnsignedShort();
    }

    void writeId(MessageOutputStream stream, int id) throws IOException {
        if (this.version == 1) {
            stream.writeInt(id);
        } else {
            stream.writeShort(id);
        }
    }

    /*
     * Exception decompiling
     */
    Object lookup(RemoteContext context, Name name, boolean preserveLinks) throws NamingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void bind(Name name, Object obj, boolean rebind) throws NamingException {
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                messageOutputStream.writeByte(rebind ? 3 : 2);
                this.writeId(messageOutputStream, invocation.getIndex());
                try (Marshaller marshaller = this.createMarshaller(messageOutputStream);){
                    if (this.version == 1) {
                        marshaller.writeByte(0);
                        marshaller.writeObject((Object)name);
                    } else {
                        marshaller.writeUTF(NamingUtils.toCompositeName(name).toString());
                    }
                    if (this.version == 1) {
                        marshaller.writeByte(1);
                    }
                    marshaller.writeObject(obj);
                }
            }
            invocation.getResponse().getInputStream().close();
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void unbind(Name name) throws NamingException {
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block28: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(6);
                    this.writeId(messageOutputStream, invocation.getIndex());
                    if (this.version == 1) {
                        try (Marshaller marshaller = this.createMarshaller(messageOutputStream);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)name);
                            break block28;
                        }
                    }
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(name).toString());
                }
            }
            invocation.getResponse().getInputStream().close();
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void rename(Name oldName, Name newName) throws NamingException {
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block28: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(7);
                    this.writeId(messageOutputStream, invocation.getIndex());
                    if (this.version == 1) {
                        try (Marshaller marshaller = this.createMarshaller(messageOutputStream);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)oldName);
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)newName);
                            break block28;
                        }
                    }
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(oldName).toString());
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(newName).toString());
                }
            }
            invocation.getResponse().getInputStream().close();
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void destroySubcontext(Name name) throws NamingException {
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block28: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(9);
                    this.writeId(messageOutputStream, invocation.getIndex());
                    if (this.version == 1) {
                        try (Marshaller marshaller = this.createMarshaller(messageOutputStream);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)name);
                            break block28;
                        }
                    }
                    messageOutputStream.writeUTF(NamingUtils.toCompositeName(name).toString());
                }
            }
            invocation.getResponse().getInputStream().close();
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    void createSubcontext(CompositeName compositeName) throws NamingException {
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        try {
            block28: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(8);
                    this.writeId(messageOutputStream, invocation.getIndex());
                    if (this.version == 1) {
                        try (Marshaller marshaller = this.createMarshaller(messageOutputStream);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)compositeName);
                            break block28;
                        }
                    }
                    messageOutputStream.writeUTF(compositeName.toString());
                }
            }
            invocation.getResponse().getInputStream().close();
        }
        catch (IOException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CloseableNamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        CompositeName compositeName = NamingUtils.toCompositeName(name);
        try {
            block59: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(4);
                    this.writeId(messageOutputStream, invocation.getIndex());
                    if (this.version == 1) {
                        try (Marshaller marshaller = this.createMarshaller(messageOutputStream);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)name);
                            break block59;
                        }
                    }
                    messageOutputStream.writeUTF(compositeName.toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            try (MessageInputStream is = response.getInputStream();){
                if (this.version == 1) {
                    if (is.readUnsignedByte() != 6) {
                        throw Messages.log.invalidResponse();
                    }
                    int listSize = is.readInt();
                    ArrayList<Object> results = new ArrayList<Object>(listSize);
                    try (Object unmarshaller = this.createUnmarshaller(is);){
                        for (int i = 0; i < listSize; ++i) {
                            results.add(unmarshaller.readObject(NameClassPair.class));
                        }
                    }
                    unmarshaller = CloseableNamingEnumeration.fromIterable(results);
                    return unmarshaller;
                }
                int listSize = is.readInt();
                ArrayList<NameClassPair> results = new ArrayList<NameClassPair>(listSize);
                for (int i = 0; i < listSize; ++i) {
                    String itemName = is.readUTF();
                    String itemClass = is.readUTF();
                    NameClassPair nameClassPair = new NameClassPair(itemName, itemClass, true);
                    CompositeName inNamespace = (CompositeName)compositeName.clone();
                    inNamespace.add(itemName);
                    nameClassPair.setNameInNamespace(inNamespace.toString());
                    results.add(nameClassPair);
                }
                CloseableNamingEnumeration<NameClassPair> closeableNamingEnumeration = CloseableNamingEnumeration.fromIterable(results);
                return closeableNamingEnumeration;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CloseableNamingEnumeration<Binding> listBindings(Name name, RemoteContext remoteContext) throws NamingException {
        BlockingInvocation invocation = (BlockingInvocation)this.tracker.addInvocation(BlockingInvocation::new);
        CompositeName compositeName = NamingUtils.toCompositeName(name);
        try {
            block55: {
                try (MessageOutputStream messageOutputStream = this.tracker.allocateMessage((Invocation)invocation);){
                    messageOutputStream.writeByte(4);
                    this.writeId(messageOutputStream, invocation.getIndex());
                    if (this.version == 1) {
                        try (Marshaller marshaller = this.createMarshaller(messageOutputStream);){
                            marshaller.writeByte(0);
                            marshaller.writeObject((Object)name);
                            break block55;
                        }
                    }
                    messageOutputStream.writeUTF(compositeName.toString());
                }
            }
            BlockingInvocation.Response response = invocation.getResponse();
            try (MessageInputStream is = response.getInputStream();){
                if (this.version == 1 && is.readUnsignedByte() != 6) {
                    throw Messages.log.invalidResponse();
                }
                int listSize = is.readInt();
                ArrayList<Object> results = new ArrayList<Object>(listSize);
                try (Unmarshaller unmarshaller = this.createUnmarshaller(is);){
                    for (int i = 0; i < listSize; ++i) {
                        int b = unmarshaller.readUnsignedByte();
                        if (b == 5) {
                            CompositeName prefix = (CompositeName)compositeName.clone();
                            String relName = unmarshaller.readUTF();
                            prefix.add(relName);
                            RelativeFederatingContext context = new RelativeFederatingContext(new FastHashtable<String, Object>(remoteContext.getEnvironment()), remoteContext, prefix);
                            results.add(new Binding(relName, context, true));
                            continue;
                        }
                        if (b != 1) throw Messages.log.invalidResponse();
                        results.add(unmarshaller.readObject(Binding.class));
                    }
                }
                CloseableNamingEnumeration<Binding> closeableNamingEnumeration = CloseableNamingEnumeration.fromIterable(results);
                return closeableNamingEnumeration;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw Messages.log.operationFailed(e);
        }
        catch (InterruptedException e) {
            invocation.cancel();
            Thread.currentThread().interrupt();
            throw Messages.log.operationInterrupted();
        }
    }

    private Unmarshaller createUnmarshaller(MessageInputStream is) throws IOException {
        Unmarshaller unmarshaller = Marshalling.getProvidedMarshallerFactory((String)"river").createUnmarshaller(this.configuration);
        unmarshaller.start(Marshalling.createByteInput((InputStream)is));
        return unmarshaller;
    }

    private Marshaller createMarshaller(MessageOutputStream os) throws IOException {
        Marshaller marshaller = Marshalling.getProvidedMarshallerFactory((String)"river").createMarshaller(this.configuration);
        marshaller.start(Marshalling.createByteOutput((OutputStream)os));
        return marshaller;
    }
}

