/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.AbstractFederatingContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteClientTransport;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.store.RelativeFederatingContext;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class RemoteContext
extends AbstractFederatingContext {
    private final RemoteNamingProvider provider;
    private final String scheme;

    RemoteContext(RemoteNamingProvider provider, String scheme, Hashtable<String, Object> env) throws CommunicationException {
        super(FastHashtable.of(env));
        this.provider = provider;
        this.scheme = scheme;
    }

    RemoteClientTransport getRemoteTransport(ConnectionPeerIdentity peerIdentity) throws NamingException {
        Endpoint endpoint = Endpoint.getCurrent();
        if (endpoint == null) {
            throw Messages.log.noRemotingEndpoint();
        }
        try {
            Connection connection = peerIdentity.getConnection();
            IoFuture future = RemoteClientTransport.SERVICE_HANDLE.getClientService(connection, OptionMap.EMPTY);
            try {
                return (RemoteClientTransport)future.getInterruptibly();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                future.cancel();
                throw Messages.log.operationInterrupted();
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof NamingException) {
                throw (NamingException)e.getCause();
            }
            throw Messages.log.connectFailed(e);
        }
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RemoteContext(this.provider, this.scheme, this.getEnvironment());
        }
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        return this.getRemoteTransport(peerIdentity).lookup(this, name, peerIdentity, false);
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RemoteContext(this.provider, this.scheme, this.getEnvironment());
        }
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        return this.getRemoteTransport(peerIdentity).lookup(this, name, peerIdentity, true);
    }

    @Override
    protected void bindNative(Name name, Object obj) throws NamingException {
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        this.getRemoteTransport(peerIdentity).bind(name, obj, peerIdentity, false);
    }

    @Override
    protected void rebindNative(Name name, Object obj) throws NamingException {
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        this.getRemoteTransport(peerIdentity).bind(name, obj, peerIdentity, true);
    }

    @Override
    protected void unbindNative(Name name) throws NamingException {
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        this.getRemoteTransport(peerIdentity).unbind(name, peerIdentity);
    }

    @Override
    protected void renameNative(Name oldName, Name newName) throws NamingException {
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        this.getRemoteTransport(peerIdentity).rename(oldName, newName, peerIdentity);
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        return this.getRemoteTransport(peerIdentity).list(name, peerIdentity);
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        return this.getRemoteTransport(peerIdentity).listBindings(name, this, peerIdentity);
    }

    @Override
    protected void destroySubcontextNative(Name name) throws NamingException {
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        this.getRemoteTransport(peerIdentity).destroySubcontext(name, peerIdentity);
    }

    @Override
    protected Context createSubcontextNative(Name name) throws NamingException {
        ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNaming();
        CompositeName compositeName = NamingUtils.toCompositeName(name);
        this.getRemoteTransport(peerIdentity).createSubcontext(compositeName, peerIdentity);
        return new RelativeFederatingContext((FastHashtable<String, Object>)this.getEnvironment(), this, compositeName);
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        String scheme = this.scheme;
        return scheme == null || scheme.isEmpty() ? "" : scheme + ":";
    }
}

