/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.function.Supplier;
import javax.naming.NamingException;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.NamingCloseable;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;

public final class RemoteNamingProvider
implements NamingProvider {
    private static final AuthenticationContextConfigurationClient CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
    private final Endpoint endpoint;
    private final Supplier<IoFuture<Connection>> connectionFactory;
    private final NamingCloseable closeable;
    private final URI providerUri;
    private final AuthenticationConfiguration authenticationConfiguration;

    RemoteNamingProvider(Endpoint endpoint, URI providerUri, AuthenticationContext context, FastHashtable<String, Object> env) {
        this.endpoint = endpoint;
        this.providerUri = providerUri;
        this.connectionFactory = () -> endpoint.getConnection(providerUri);
        this.closeable = NamingCloseable.NULL;
        this.authenticationConfiguration = CLIENT.getAuthenticationConfiguration(providerUri, context, -1, "jndi", "jboss", "operate");
    }

    RemoteNamingProvider(Connection connection, AuthenticationContext context, FastHashtable<String, Object> env) {
        URI providerUri;
        this.endpoint = connection.getEndpoint();
        this.providerUri = providerUri = connection.getPeerURI();
        this.authenticationConfiguration = CLIENT.getAuthenticationConfiguration(providerUri, context, -1, "jndi", "jboss", "operate");
        this.connectionFactory = () -> new FinishedIoFuture((Object)connection);
        this.closeable = () -> {
            try {
                connection.close();
            }
            catch (IOException e) {
                throw Messages.log.namingProviderCloseFailed(e);
            }
        };
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ConnectionPeerIdentity getPeerIdentityForNaming() throws NamingException {
        try {
            return this.getPeerIdentity();
        }
        catch (IOException e) {
            throw Messages.log.connectFailed(e);
        }
        catch (AuthenticationException e) {
            throw Messages.log.authenticationFailed(e);
        }
    }

    public ConnectionPeerIdentity getPeerIdentity() throws AuthenticationException, IOException {
        Connection connection = (Connection)this.connectionFactory.get().get();
        if (connection.supportsRemoteAuth()) {
            return connection.getPeerIdentityContext().authenticate(this.authenticationConfiguration);
        }
        return connection.getConnectionPeerIdentity();
    }

    public IoFuture<ConnectionPeerIdentity> getFuturePeerIdentity() {
        FutureResult futureResult = new FutureResult();
        this.connectionFactory.get().addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, FutureResult<ConnectionPeerIdentity>>(){

            public void handleCancelled(FutureResult<ConnectionPeerIdentity> attachment) {
                attachment.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<ConnectionPeerIdentity> attachment) {
                attachment.setException(exception);
            }

            public void handleDone(Connection data, FutureResult<ConnectionPeerIdentity> attachment) {
                try {
                    if (data.supportsRemoteAuth()) {
                        attachment.setResult((Object)data.getPeerIdentityContext().authenticate(RemoteNamingProvider.this.authenticationConfiguration));
                    } else {
                        attachment.setResult((Object)data.getConnectionPeerIdentity());
                    }
                }
                catch (AuthenticationException e) {
                    attachment.setException((IOException)new javax.security.sasl.AuthenticationException(e.getMessage(), e));
                }
            }
        }, (Object)futureResult);
        return futureResult.getIoFuture();
    }

    @Override
    public URI getProviderUri() {
        return this.providerUri;
    }

    @Override
    public void close() throws NamingException {
        this.closeable.close();
    }
}

