/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import javax.management.RuntimeMBeanException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.util.MessageTracker;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.ProtocolUtils;
import org.xnio.IoUtils;

final class RemoteServerTransport {
    private final MarshallingConfiguration configuration;
    private final Channel channel;
    private final int version;
    private final Context localContext;
    private final MessageTracker messageTracker;

    RemoteServerTransport(Channel channel, int version, MessageTracker messageTracker, Context localContext) {
        this.channel = channel;
        this.version = version;
        this.messageTracker = messageTracker;
        this.localContext = localContext;
        this.configuration = new MarshallingConfiguration();
        this.configuration.setVersion(version == 2 ? 4 : 2);
        this.configuration.setClassResolver((ClassResolver)new ContextClassResolver());
    }

    public void start() {
        this.channel.receiveMessage(new Channel.Receiver(){

            public void handleError(Channel channel, IOException error) {
                IoUtils.safeClose((Closeable)channel);
            }

            public void handleEnd(Channel channel) {
                IoUtils.safeClose((Closeable)channel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Channel channel, MessageInputStream message) {
                block34: {
                    try (MessageInputStream mis = message;){
                        byte messageId = mis.readByte();
                        int id = ProtocolUtils.readId(mis, RemoteServerTransport.this.version);
                        try {
                            switch (messageId) {
                                case 1: {
                                    RemoteServerTransport.this.handleLookup(mis, messageId, id, false);
                                    break;
                                }
                                case 16: {
                                    RemoteServerTransport.this.handleLookup(mis, messageId, id, true);
                                    break;
                                }
                                case 2: {
                                    RemoteServerTransport.this.handleBind(mis, messageId, id, false);
                                    break;
                                }
                                case 3: {
                                    RemoteServerTransport.this.handleBind(mis, messageId, id, true);
                                    break;
                                }
                                case 6: {
                                    RemoteServerTransport.this.handleUnbind(mis, messageId, id);
                                    break;
                                }
                                case 7: {
                                    RemoteServerTransport.this.handleRename(mis, messageId, id);
                                    break;
                                }
                                case 9: {
                                    RemoteServerTransport.this.handleDestroySubcontext(mis, messageId, id);
                                    break;
                                }
                                case 8: {
                                    RemoteServerTransport.this.handleCreateSubcontext(mis, messageId, id);
                                    break;
                                }
                                case 4: {
                                    RemoteServerTransport.this.handleList(mis, messageId, id);
                                    break;
                                }
                                case 5: {
                                    RemoteServerTransport.this.handleListBindings(mis, messageId, id);
                                    break;
                                }
                                default: {
                                    throw Messages.log.unrecognizedMessageId();
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (id != 0) {
                                Exception response;
                                if (t instanceof IOException || t instanceof RuntimeMBeanException) {
                                    response = (Exception)t;
                                } else {
                                    response = new IOException("Internal server error.");
                                    Messages.log.unexpectedError(t);
                                }
                                RemoteServerTransport.this.sendException(response, messageId, id);
                                break block34;
                            }
                            Messages.log.nullCorrelationId(t);
                        }
                    }
                    catch (Throwable t) {
                        Messages.log.unexpectedError(t);
                    }
                    finally {
                        channel.receiveMessage((Channel.Receiver)this);
                    }
                }
            }
        });
    }

    void handleLookup(MessageInputStream message, int messageId, int id, boolean preserveLinks) throws IOException {
        Object result;
        block30: {
            try (MessageInputStream mis = message;){
                if (this.version == 1) {
                    try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                        int parameterType = unmarshaller.readUnsignedByte();
                        if (parameterType != 0) {
                            Messages.log.unexpectedParameterType(0, parameterType);
                        }
                        Name name = (Name)unmarshaller.readObject(Name.class);
                        result = preserveLinks ? this.localContext.lookupLink(name) : this.localContext.lookup(name);
                        break block30;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e);
                    }
                }
                mis.readInt();
                String name = mis.readUTF();
                result = preserveLinks ? this.localContext.lookupLink(name) : this.localContext.lookup(name);
            }
            catch (NamingException e) {
                this.writeExceptionResponse(e, messageId, id);
                return;
            }
        }
        this.writeSuccessResponse(messageId, id, result);
    }

    void handleBind(MessageInputStream message, int messageId, int id, boolean rebind) throws IOException {
        block46: {
            try (MessageInputStream mis = message;){
                if (this.version == 1) {
                    try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                        int parameterType = unmarshaller.readUnsignedByte();
                        if (parameterType != 0) {
                            Messages.log.unexpectedParameterType(0, parameterType);
                        }
                        Name name = (Name)unmarshaller.readObject(Name.class);
                        parameterType = unmarshaller.readUnsignedByte();
                        if (parameterType != 1) {
                            Messages.log.unexpectedParameterType(1, parameterType);
                        }
                        Object object = unmarshaller.readObject();
                        if (rebind) {
                            this.localContext.rebind(name, object);
                        } else {
                            this.localContext.bind(name, object);
                        }
                        break block46;
                    }
                }
                mis.readInt();
                String name = mis.readUTF();
                try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                    Object object = unmarshaller.readObject();
                    if (rebind) {
                        this.localContext.rebind(name, object);
                    } else {
                        this.localContext.bind(name, object);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (NamingException e) {
                this.writeExceptionResponse(e, messageId, id);
                return;
            }
        }
        this.writeSuccessResponse(messageId, id);
    }

    void handleUnbind(MessageInputStream message, int messageId, int id) throws IOException {
        block30: {
            try (MessageInputStream mis = message;){
                if (this.version == 1) {
                    try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                        int parameterType = unmarshaller.readUnsignedByte();
                        if (parameterType != 0) {
                            Messages.log.unexpectedParameterType(0, parameterType);
                        }
                        Name name = (Name)unmarshaller.readObject(Name.class);
                        this.localContext.unbind(name);
                        break block30;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e);
                    }
                }
                mis.readInt();
                String name = mis.readUTF();
                this.localContext.unbind(name);
            }
            catch (NamingException e) {
                this.writeExceptionResponse(e, messageId, id);
                return;
            }
        }
        this.writeSuccessResponse(messageId, id);
    }

    void handleRename(MessageInputStream message, int messageId, int id) throws IOException {
        block31: {
            try (MessageInputStream mis = message;){
                if (this.version == 1) {
                    try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                        int parameterType = unmarshaller.readUnsignedByte();
                        if (parameterType != 0) {
                            Messages.log.unexpectedParameterType(0, parameterType);
                        }
                        Name oldName = (Name)unmarshaller.readObject(Name.class);
                        parameterType = unmarshaller.readUnsignedByte();
                        if (parameterType != 0) {
                            Messages.log.unexpectedParameterType(0, parameterType);
                        }
                        Name newName = (Name)unmarshaller.readObject(Name.class);
                        this.localContext.rename(oldName, newName);
                        break block31;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e);
                    }
                }
                mis.readInt();
                String oldName = mis.readUTF();
                String newName = mis.readUTF();
                this.localContext.rename(oldName, newName);
            }
            catch (NamingException e) {
                this.writeExceptionResponse(e, messageId, id);
                return;
            }
        }
        this.writeSuccessResponse(messageId, id);
    }

    void handleDestroySubcontext(MessageInputStream message, int messageId, int id) throws IOException {
        block30: {
            try (MessageInputStream mis = message;){
                if (this.version == 1) {
                    try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                        int parameterType = unmarshaller.readUnsignedByte();
                        if (parameterType != 0) {
                            Messages.log.unexpectedParameterType(0, parameterType);
                        }
                        Name name = (Name)unmarshaller.readObject(Name.class);
                        this.localContext.destroySubcontext(name);
                        break block30;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e);
                    }
                }
                mis.readInt();
                String name = mis.readUTF();
                this.localContext.destroySubcontext(name);
            }
            catch (NamingException e) {
                this.writeExceptionResponse(e, messageId, id);
                return;
            }
        }
        this.writeSuccessResponse(messageId, id);
    }

    void handleCreateSubcontext(MessageInputStream message, int messageId, int id) throws IOException {
        Context result;
        block30: {
            try (MessageInputStream mis = message;){
                if (this.version == 1) {
                    try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                        int parameterType = unmarshaller.readUnsignedByte();
                        if (parameterType != 0) {
                            Messages.log.unexpectedParameterType(0, parameterType);
                        }
                        Name name = (Name)unmarshaller.readObject(Name.class);
                        result = this.localContext.createSubcontext(name);
                        break block30;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e);
                    }
                }
                mis.readInt();
                String name = mis.readUTF();
                result = this.localContext.createSubcontext(name);
            }
            catch (NamingException e) {
                this.writeExceptionResponse(e, messageId, id);
                return;
            }
        }
        this.writeSuccessResponse(messageId, id, result);
    }

    void handleList(MessageInputStream message, int messageId, int id) throws IOException {
        block60: {
            ArrayList<NameClassPair> resultList;
            Throwable throwable;
            Throwable throwable2;
            try {
                throwable2 = null;
                try (MessageInputStream mis = message;){
                    NamingEnumeration<NameClassPair> results;
                    block58: {
                        if (this.version == 1) {
                            try {
                                throwable = null;
                                try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                                    int parameterType = unmarshaller.readUnsignedByte();
                                    if (parameterType != 0) {
                                        Messages.log.unexpectedParameterType(0, parameterType);
                                    }
                                    Name name = (Name)unmarshaller.readObject(Name.class);
                                    results = this.localContext.list(name);
                                    break block58;
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                            }
                            catch (ClassNotFoundException e) {
                                throw new IOException(e);
                            }
                        }
                        mis.readInt();
                        String name = mis.readUTF();
                        results = this.localContext.list(name);
                    }
                    resultList = new ArrayList<NameClassPair>();
                    while (results.hasMore()) {
                        resultList.add(results.next());
                    }
                }
                catch (Throwable name) {
                    throwable2 = name;
                    throw name;
                }
            }
            catch (NamingException e) {
                this.writeExceptionResponse(e, messageId, id);
                return;
            }
            throwable2 = null;
            try (MessageOutputStream mos = this.messageTracker.openMessageUninterruptibly();){
                mos.writeByte(messageId);
                ProtocolUtils.writeId(mos, this.version, id);
                mos.writeByte(0);
                if (this.version == 1) {
                    mos.writeByte(6);
                    mos.writeInt(resultList.size());
                    throwable = null;
                    try (Marshaller marshaller = ProtocolUtils.createMarshaller(mos, this.configuration);){
                        for (NameClassPair nameClassPair : resultList) {
                            marshaller.writeObject((Object)nameClassPair);
                        }
                        break block60;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                mos.writeInt(resultList.size());
                for (NameClassPair nameClassPair : resultList) {
                    mos.writeUTF(nameClassPair.getName());
                    mos.writeUTF(nameClassPair.getClassName());
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
    }

    void handleListBindings(MessageInputStream message, int messageId, int id) throws IOException {
        ArrayList<Binding> resultList;
        Throwable throwable;
        Throwable throwable2;
        try {
            throwable2 = null;
            try (MessageInputStream mis = message;){
                NamingEnumeration<Binding> results;
                block58: {
                    if (this.version == 1) {
                        try {
                            throwable = null;
                            try (Unmarshaller unmarshaller = ProtocolUtils.createUnmarshaller(mis, this.configuration);){
                                int parameterType = unmarshaller.readUnsignedByte();
                                if (parameterType != 0) {
                                    Messages.log.unexpectedParameterType(0, parameterType);
                                }
                                Name name = (Name)unmarshaller.readObject(Name.class);
                                results = this.localContext.listBindings(name);
                                break block58;
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException(e);
                        }
                    }
                    mis.readInt();
                    String name = mis.readUTF();
                    results = this.localContext.listBindings(name);
                }
                resultList = new ArrayList<Binding>();
                while (results.hasMore()) {
                    resultList.add(results.next());
                }
            }
            catch (Throwable name) {
                throwable2 = name;
                throw name;
            }
        }
        catch (NamingException e) {
            this.writeExceptionResponse(e, messageId, id);
            return;
        }
        throwable2 = null;
        try (MessageOutputStream mos = this.messageTracker.openMessageUninterruptibly();){
            mos.writeByte(messageId);
            ProtocolUtils.writeId(mos, this.version, id);
            mos.writeByte(0);
            if (this.version == 1) {
                mos.writeByte(6);
            }
            mos.writeInt(resultList.size());
            throwable = null;
            try (Marshaller marshaller = ProtocolUtils.createMarshaller(mos, this.configuration);){
                for (Binding binding : resultList) {
                    if (binding.getObject() instanceof Context) {
                        marshaller.writeByte(5);
                        marshaller.writeUTF(binding.getName());
                        continue;
                    }
                    marshaller.writeByte(4);
                    marshaller.writeObject((Object)binding);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (Throwable throwable5) {
            throwable2 = throwable5;
            throw throwable5;
        }
    }

    private void writeSuccessResponse(int messageId, int id) throws IOException {
        try (MessageOutputStream mos = this.messageTracker.openMessageUninterruptibly();){
            mos.writeByte(messageId);
            ProtocolUtils.writeId(mos, this.version, id);
            mos.writeByte(0);
        }
    }

    private void writeSuccessResponse(int messageId, int id, Object result) throws IOException {
        block25: {
            try (MessageOutputStream mos = this.messageTracker.openMessageUninterruptibly();){
                mos.writeByte(messageId);
                ProtocolUtils.writeId(mos, this.version, id);
                mos.writeByte(0);
                if (result instanceof Context) {
                    mos.writeByte(5);
                    break block25;
                }
                mos.writeByte(1);
                try (Marshaller marshaller = ProtocolUtils.createMarshaller(mos, this.configuration);){
                    marshaller.writeObject(result);
                }
            }
        }
    }

    private void writeExceptionResponse(Exception e, int messageId, int id) throws IOException {
        try (MessageOutputStream mos = this.messageTracker.openMessageUninterruptibly();){
            mos.writeByte(messageId);
            ProtocolUtils.writeId(mos, this.version, id);
            mos.writeByte(1);
            mos.writeByte(2);
            try (Marshaller marshaller = ProtocolUtils.createMarshaller(mos, this.configuration);){
                marshaller.writeObject((Object)e);
            }
        }
    }

    private void sendException(Exception e, int messageId, int id) {
        try {
            this.writeExceptionResponse(e, messageId, id);
        }
        catch (IOException ioe) {
            Messages.log.failedToSendExceptionResponse(ioe);
        }
    }
}

