/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client._private;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InterruptedNamingException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.naming.client.RenameAcrossNamingProvidersException;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.security.auth.AuthenticationException;

public class Messages_$logger
extends DelegatingBasicLogger
implements Messages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String serviceConfigFailed = "Service configuration failure loading naming providers";
    private static final String greeting = "WildFly Naming version %s";
    private static final String invalidProviderUri = "WFNAM00003: Invalid naming provider URI: %s";
    private static final String nameNotFound = "WFNAM00004: Name \"%s\" is not found";
    private static final String invalidEmptyName = "WFNAM00005: Invalid empty name";
    private static final String readOnlyContext = "WFNAM00006: Cannot modify read-only naming context";
    private static final String invalidURLSchemeName = "WFNAM00007: Invalid URL scheme name \"%s\"";
    private static final String nameIndexOutOfBounds = "WFNAM00009: Name index %d is out of bounds";
    private static final String invalidNullSegment = "WFNAM00010: Invalid null name segment at index %d";
    private static final String missingCloseQuote = "WFNAM00011: Missing close quote '%s' in name \"%s\"";
    private static final String missingEscape = "WFNAM00012: Unterminated escape sequence in name \"%s\"";
    private static final String renameAcrossProviders = "WFNAM00014: Renaming from \"%s\" to \"%s\" across providers is not supported";
    private static final String notContextInCompositeName = "WFNAM00015: Composite name segment \"%s\" does not refer to a context";
    private static final String contextCloseFailed = "WFNAM00016: Closing context \"%s\" failed";
    private static final String noRemotingEndpoint = "WFNAM00017: No JBoss Remoting endpoint has been configured";
    private static final String connectFailed = "WFNAM00018: Failed to connect to remote host";
    private static final String operationInterrupted = "WFNAM00019: Naming operation interrupted";
    private static final String operationFailed = "WFNAM00020: Remote naming operation failed";
    private static final String noCompatibleVersions = "WFNAM00022: The server provided no compatible protocol versions";
    private static final String invalidResponse = "WFNAM00023: Received an invalid response from the server";
    private static final String notSupported = "WFNAM00024: Naming operation not supported";
    private static final String oldContextDeprecated = "WFNAM00025: org.jboss.naming.remote.client.InitialContextFactory is deprecated; new applications should use org.wildfly.naming.client.WildFlyInitialContextFactory instead";
    private static final String noProviderForUri = "WFNAM00026: No provider for found for URI: %s";
    private static final String invalidHeader = "WFNAM00029: Invalid leading bytes in header";
    private static final String outcomeNotUnderstood = "WFNAM00031: Outcome not understood";
    private static final String authenticationFailed = "WFNAM00032: Peer authentication failed";
    private static final String connectionSharingUnsupported = "WFNAM00033: Connection sharing not supported";
    private static final String unexpectedParameterType = "WFNAM00034: Unexpected parameter type - expected: %d  received: %d";
    private static final String failedToSendExceptionResponse = "WFNAM00035: Failed to send exception response to client";
    private static final String unexpectedError = "WFNAM00036: Unexpected internal error";
    private static final String nullCorrelationId = "WFNAM00037: null correlationId so error not sent to client";
    private static final String unrecognizedMessageId = "WFNAM00038: Unrecognized messageId";
    private static final String failedToSendHeader = "WFNAM00039: Unable to send header, closing channel";
    private static final String unsupportedProtocolVersion = "WFNAM00040: Unsupported protocol version [ %d ]";
    private static final String failedToDetermineClientVersion = "WFNAM00041: Error determining version selected by client";
    private static final String callbackHandlerAndUsernameAndPasswordSpecified = "WFNAM00042: Cannot specify both a callback handler and a username/password for connection";
    private static final String failedToLoadCallbackHandlerClass = "WFNAM00043: Unable to load callback handler class \"%s\"";
    private static final String failedToInstantiateCallbackHandlerInstance = "WFNAM00044: Unable to instantiate callback handler instance of type  \"%s\"";
    private static final String deprecatedProperties = "WFNAM00049: Usage of the legacy \"remote.connections\" property is deprecated; please use javax.naming.Context#PROVIDER_URL instead";
    private static final AtomicBoolean deprecatedProperties_$Once = new AtomicBoolean(false);
    private static final String ignoringLegacyProperties = "WFNAM00051: Provider URLs already given via standard mechanism; ignoring legacy property-based connection configuration";
    private static final String invalidNumericProperty = "WFNAM00052: Invalid value given for property \"%s\": \"%s\" is not numeric";
    private static final String invalidProviderGenerated = "WFNAM00053: Failed to synthesize a valid provider URL";
    private static final String ignoringDuplicateDestination = "WFNAM00054: Ignoring duplicate destination URI \"%s\"";

    public Messages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serviceConfigFailed(ServiceConfigurationError error) {
        this.log.logf(FQCN, Logger.Level.TRACE, (Throwable)error, this.serviceConfigFailed$str(), new Object[0]);
    }

    protected String serviceConfigFailed$str() {
        return serviceConfigFailed;
    }

    @Override
    public final void greeting(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.greeting$str(), (Object)version);
    }

    protected String greeting$str() {
        return greeting;
    }

    protected String invalidProviderUri$str() {
        return invalidProviderUri;
    }

    @Override
    public final ConfigurationException invalidProviderUri(Exception cause, Object providerUri) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.invalidProviderUri$str(), providerUri));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nameNotFound$str() {
        return nameNotFound;
    }

    @Override
    public final NameNotFoundException nameNotFound(Name name1, Name name) {
        NameNotFoundException result = new NameNotFoundException(String.format(this.getLoggingLocale(), this.nameNotFound$str(), name1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.setResolvedName(name);
        return result;
    }

    protected String invalidEmptyName$str() {
        return invalidEmptyName;
    }

    @Override
    public final InvalidNameException invalidEmptyName() {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.invalidEmptyName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String readOnlyContext$str() {
        return readOnlyContext;
    }

    @Override
    public final NoPermissionException readOnlyContext() {
        NoPermissionException result = new NoPermissionException(String.format(this.getLoggingLocale(), this.readOnlyContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidURLSchemeName$str() {
        return invalidURLSchemeName;
    }

    @Override
    public final InvalidNameException invalidURLSchemeName(String name) {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.invalidURLSchemeName$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nameIndexOutOfBounds$str() {
        return nameIndexOutOfBounds;
    }

    @Override
    public final IndexOutOfBoundsException nameIndexOutOfBounds(int pos) {
        IndexOutOfBoundsException result = new IndexOutOfBoundsException(String.format(this.getLoggingLocale(), this.nameIndexOutOfBounds$str(), pos));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullSegment$str() {
        return invalidNullSegment;
    }

    @Override
    public final IllegalArgumentException invalidNullSegment(int index) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullSegment$str(), index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCloseQuote$str() {
        return missingCloseQuote;
    }

    @Override
    public final InvalidNameException missingCloseQuote(char quote, String name) {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.missingCloseQuote$str(), Character.valueOf(quote), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingEscape$str() {
        return missingEscape;
    }

    @Override
    public final InvalidNameException missingEscape(String name) {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.missingEscape$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String renameAcrossProviders$str() {
        return renameAcrossProviders;
    }

    @Override
    public final RenameAcrossNamingProvidersException renameAcrossProviders(Name oldName, Name newName) {
        RenameAcrossNamingProvidersException result = new RenameAcrossNamingProvidersException(String.format(this.getLoggingLocale(), this.renameAcrossProviders$str(), oldName, newName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notContextInCompositeName$str() {
        return notContextInCompositeName;
    }

    @Override
    public final NotContextException notContextInCompositeName(String segment) {
        NotContextException result = new NotContextException(String.format(this.getLoggingLocale(), this.notContextInCompositeName$str(), segment));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void contextCloseFailed(Context context, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.contextCloseFailed$str(), (Object)context);
    }

    protected String contextCloseFailed$str() {
        return contextCloseFailed;
    }

    protected String noRemotingEndpoint$str() {
        return noRemotingEndpoint;
    }

    @Override
    public final CommunicationException noRemotingEndpoint() {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.noRemotingEndpoint$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectFailed$str() {
        return connectFailed;
    }

    @Override
    public final CommunicationException connectFailed(Throwable cause) {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.connectFailed$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String operationInterrupted$str() {
        return operationInterrupted;
    }

    @Override
    public final InterruptedNamingException operationInterrupted() {
        InterruptedNamingException result = new InterruptedNamingException(String.format(this.getLoggingLocale(), this.operationInterrupted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String operationFailed$str() {
        return operationFailed;
    }

    @Override
    public final CommunicationException operationFailed(Throwable cause) {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.operationFailed$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCompatibleVersions$str() {
        return noCompatibleVersions;
    }

    @Override
    public final CommunicationException noCompatibleVersions() {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.noCompatibleVersions$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidResponse$str() {
        return invalidResponse;
    }

    @Override
    public final CommunicationException invalidResponse() {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.invalidResponse$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notSupported$str() {
        return notSupported;
    }

    @Override
    public final OperationNotSupportedException notSupported() {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.getLoggingLocale(), this.notSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void oldContextDeprecated() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.oldContextDeprecated$str(), new Object[0]);
    }

    protected String oldContextDeprecated$str() {
        return oldContextDeprecated;
    }

    protected String noProviderForUri$str() {
        return noProviderForUri;
    }

    @Override
    public final OperationNotSupportedException noProviderForUri(String uri) {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.getLoggingLocale(), this.noProviderForUri$str(), uri));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidHeader$str() {
        return invalidHeader;
    }

    @Override
    public final CommunicationException invalidHeader() {
        CommunicationException result = new CommunicationException(String.format(this.getLoggingLocale(), this.invalidHeader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String outcomeNotUnderstood$str() {
        return outcomeNotUnderstood;
    }

    @Override
    public final IOException outcomeNotUnderstood() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.outcomeNotUnderstood$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String authenticationFailed$str() {
        return authenticationFailed;
    }

    @Override
    public final javax.naming.AuthenticationException authenticationFailed(AuthenticationException cause) {
        javax.naming.AuthenticationException result = new javax.naming.AuthenticationException(String.format(this.getLoggingLocale(), this.authenticationFailed$str(), new Object[0]));
        result.initCause((Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionSharingUnsupported$str() {
        return connectionSharingUnsupported;
    }

    @Override
    public final javax.naming.AuthenticationException connectionSharingUnsupported() {
        javax.naming.AuthenticationException result = new javax.naming.AuthenticationException(String.format(this.getLoggingLocale(), this.connectionSharingUnsupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unexpectedParameterType(int expected, int actual) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unexpectedParameterType$str(), (Object)expected, (Object)actual);
    }

    protected String unexpectedParameterType$str() {
        return unexpectedParameterType;
    }

    @Override
    public final void failedToSendExceptionResponse(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToSendExceptionResponse$str(), new Object[0]);
    }

    protected String failedToSendExceptionResponse$str() {
        return failedToSendExceptionResponse;
    }

    @Override
    public final void unexpectedError(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.unexpectedError$str(), new Object[0]);
    }

    protected String unexpectedError$str() {
        return unexpectedError;
    }

    @Override
    public final void nullCorrelationId(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.nullCorrelationId$str(), new Object[0]);
    }

    protected String nullCorrelationId$str() {
        return nullCorrelationId;
    }

    protected String unrecognizedMessageId$str() {
        return unrecognizedMessageId;
    }

    @Override
    public final IOException unrecognizedMessageId() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unrecognizedMessageId$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void failedToSendHeader(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendHeader$str(), new Object[0]);
    }

    protected String failedToSendHeader$str() {
        return failedToSendHeader;
    }

    protected String unsupportedProtocolVersion$str() {
        return unsupportedProtocolVersion;
    }

    @Override
    public final IllegalArgumentException unsupportedProtocolVersion(int version) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedProtocolVersion$str(), version));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void failedToDetermineClientVersion(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToDetermineClientVersion$str(), new Object[0]);
    }

    protected String failedToDetermineClientVersion$str() {
        return failedToDetermineClientVersion;
    }

    protected String callbackHandlerAndUsernameAndPasswordSpecified$str() {
        return callbackHandlerAndUsernameAndPasswordSpecified;
    }

    @Override
    public final RuntimeException callbackHandlerAndUsernameAndPasswordSpecified() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.callbackHandlerAndUsernameAndPasswordSpecified$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToLoadCallbackHandlerClass$str() {
        return failedToLoadCallbackHandlerClass;
    }

    @Override
    public final RuntimeException failedToLoadCallbackHandlerClass(Exception cause, String callbackHandlerClass) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToLoadCallbackHandlerClass$str(), callbackHandlerClass), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToInstantiateCallbackHandlerInstance$str() {
        return failedToInstantiateCallbackHandlerInstance;
    }

    @Override
    public final NamingException failedToInstantiateCallbackHandlerInstance(Exception cause, String callbackHandlerClass) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.failedToInstantiateCallbackHandlerInstance$str(), callbackHandlerClass));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void deprecatedProperties() {
        if (this.log.isEnabled(Logger.Level.INFO) && deprecatedProperties_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.INFO, null, this.deprecatedProperties$str(), new Object[0]);
        }
    }

    protected String deprecatedProperties$str() {
        return deprecatedProperties;
    }

    @Override
    public final void ignoringLegacyProperties() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringLegacyProperties$str(), new Object[0]);
    }

    protected String ignoringLegacyProperties$str() {
        return ignoringLegacyProperties;
    }

    protected String invalidNumericProperty$str() {
        return invalidNumericProperty;
    }

    @Override
    public final ConfigurationException invalidNumericProperty(Throwable e, String propertyName, String resultStr) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.invalidNumericProperty$str(), propertyName, resultStr));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidProviderGenerated$str() {
        return invalidProviderGenerated;
    }

    @Override
    public final ConfigurationException invalidProviderGenerated(Throwable e) {
        ConfigurationException result = new ConfigurationException(String.format(this.getLoggingLocale(), this.invalidProviderGenerated$str(), new Object[0]));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void ignoringDuplicateDestination(URI uri) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringDuplicateDestination$str(), (Object)uri);
    }

    protected String ignoringDuplicateDestination$str() {
        return ignoringDuplicateDestination;
    }
}

