/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.common.model.validator;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class ElementMaxOccurrenceValidationStepHandler
implements ModelValidationStepHandler {
    private final int maxOccurs;
    private final ModelElement parentElement;
    private final ModelElement element;

    public ElementMaxOccurrenceValidationStepHandler(ModelElement element, ModelElement parentElement, int maxOccurs) {
        this.element = element;
        this.parentElement = parentElement;
        this.maxOccurs = maxOccurs;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validateOccurrence(context, operation);
    }

    protected void validateOccurrence(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathAddress parentAddress = Util.getParentAddressByKey((PathAddress)address, (String)this.parentElement.getName());
        Resource parentResource = context.readResourceFromRoot(parentAddress);
        Set elements = parentResource.getChildrenNames(this.element.getName());
        if (elements.size() > this.maxOccurs) {
            throw PicketLinkLogger.ROOT_LOGGER.invalidChildTypeOccurrence(parentAddress.getLastElement().toString(), this.maxOccurs, this.element.getName());
        }
    }
}

