package org.wildfly.extension.picketlink.logging;

import java.util.Locale;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import org.picketlink.common.exceptions.ProcessingException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-25T20:13:57-0500")
public class PicketLinkLogger_$logger extends DelegatingBasicLogger implements PicketLinkLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = PicketLinkLogger_$logger.class.getName();
    public PicketLinkLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem(final String name) {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str(), name);
    }
    private static final String activatingSubsystem = "WFLYPL0001: Activating PicketLink %s Subsystem";
    protected String activatingSubsystem$str() {
        return activatingSubsystem;
    }
    @Override
    public final void federationConfiguringDeployment(final String deploymentName) {
        super.log.logf(FQCN, INFO, null, federationConfiguringDeployment$str(), deploymentName);
    }
    private static final String federationConfiguringDeployment = "WFLYPL0002: Configuring PicketLink Federation for deployment [%s]";
    protected String federationConfiguringDeployment$str() {
        return federationConfiguringDeployment;
    }
    @Override
    public final void boundToJndi(final String alias, final String jndiName) {
        super.log.logf(FQCN, INFO, null, boundToJndi$str(), alias, jndiName);
    }
    private static final String boundToJndi = "WFLYPL0003: Bound [%s] to [%s]";
    protected String boundToJndi$str() {
        return boundToJndi;
    }
    @Override
    public final void federationIgnoringAuditEvent(final PicketLinkAuditEventType eventType) {
        super.log.logf(FQCN, INFO, null, federationIgnoringAuditEvent$str(), eventType);
    }
    private static final String federationIgnoringAuditEvent = "WFLYPL0004: Ignoring unexpected event type [%s]";
    protected String federationIgnoringAuditEvent$str() {
        return federationIgnoringAuditEvent;
    }
    @Override
    public final void federationErrorCollectingMetric(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, federationErrorCollectingMetric$str());
    }
    private static final String federationErrorCollectingMetric = "WFLYPL0005: Error while configuring the metrics collector. Metrics will not be collected.";
    protected String federationErrorCollectingMetric$str() {
        return federationErrorCollectingMetric;
    }
    private static final String moduleCouldNotLoad = "WFLYPL0007: Could not load module [%s].";
    protected String moduleCouldNotLoad$str() {
        return moduleCouldNotLoad;
    }
    @Override
    public final RuntimeException moduleCouldNotLoad(final String s, final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), moduleCouldNotLoad$str(), s), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotLoadClass = "WFLYPL0009: Could not load class [%s].";
    protected String couldNotLoadClass$str() {
        return couldNotLoadClass;
    }
    @Override
    public final RuntimeException couldNotLoadClass(final String mappingClass, final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotLoadClass$str(), mappingClass), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typeNotProvided = "WFLYPL0010: No type provided for %s. You must specify a class-name or code.";
    protected String typeNotProvided$str() {
        return typeNotProvided;
    }
    @Override
    public final OperationFailedException typeNotProvided(final String elementName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), typeNotProvided$str(), elementName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToGetMetrics = "WFLYPL0011: Failed to get metrics %s.";
    protected String failedToGetMetrics$str() {
        return failedToGetMetrics;
    }
    @Override
    public final OperationFailedException failedToGetMetrics(final String reason) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToGetMetrics$str(), reason));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeNoLongerSupported = "WFLYPL0012: Attribute [%s] is not longer supported.";
    protected String attributeNoLongerSupported$str() {
        return attributeNoLongerSupported;
    }
    @Override
    public final OperationFailedException attributeNoLongerSupported(final String attributeName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), attributeNoLongerSupported$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidChildTypeOccurrence = "WFLYPL0013: [%s] can only have [%d] child of type [%s].";
    protected String invalidChildTypeOccurrence$str() {
        return invalidChildTypeOccurrence;
    }
    @Override
    public final OperationFailedException invalidChildTypeOccurrence(final String parentPathElement, final int maxOccurs, final String elementName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidChildTypeOccurrence$str(), parentPathElement, maxOccurs, elementName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAlternativeAttributeOccurrence = "WFLYPL0014: Invalid attribute [%s] definition for [%s]. Only one of the following attributes are allowed: [%s].";
    protected String invalidAlternativeAttributeOccurrence$str() {
        return invalidAlternativeAttributeOccurrence;
    }
    @Override
    public final OperationFailedException invalidAlternativeAttributeOccurrence(final String attributeName, final String pathElement, final String attributeNames) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidAlternativeAttributeOccurrence$str(), attributeName, pathElement, attributeNames));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredAttribute = "WFLYPL0015: Required attribute [%s] for [%s].";
    protected String requiredAttribute$str() {
        return requiredAttribute;
    }
    @Override
    public final OperationFailedException requiredAttribute(final String attributeName, final String configuration) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), requiredAttribute$str(), attributeName, configuration));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredAlternativeAttributes = "WFLYPL0016: [%s] requires one of the given attributes [%s].";
    protected String requiredAlternativeAttributes$str() {
        return requiredAlternativeAttributes;
    }
    @Override
    public final OperationFailedException requiredAlternativeAttributes(final String pathElement, final String attributeNames) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), requiredAlternativeAttributes$str(), pathElement, attributeNames));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typeAlreadyDefined = "WFLYPL0017: Type [%s] already defined.";
    protected String typeAlreadyDefined$str() {
        return typeAlreadyDefined;
    }
    @Override
    public final IllegalStateException typeAlreadyDefined(final String clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), typeAlreadyDefined$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String emptyResource = "WFLYPL0018: [%s] can not be empty.";
    protected String emptyResource$str() {
        return emptyResource;
    }
    @Override
    public final OperationFailedException emptyResource(final String parentPathElement) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), emptyResource$str(), parentPathElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredChild = "WFLYPL0019: [%s] requires child [%s].";
    protected String requiredChild$str() {
        return requiredChild;
    }
    @Override
    public final OperationFailedException requiredChild(final String parentPathElement, final String childPathElement) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), requiredChild$str(), parentPathElement, childPathElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idmJpaEntityModuleNotFound = "WFLYPL0050: Entities module not found [%s].";
    protected String idmJpaEntityModuleNotFound$str() {
        return idmJpaEntityModuleNotFound;
    }
    @Override
    public final SecurityConfigurationException idmJpaEntityModuleNotFound(final String entityModuleName) {
        final SecurityConfigurationException result = new SecurityConfigurationException(String.format(getLoggingLocale(), idmJpaEntityModuleNotFound$str(), entityModuleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idmJpaStartFailed = "WFLYPL0051: Could not configure JPA store.";
    protected String idmJpaStartFailed$str() {
        return idmJpaStartFailed;
    }
    @Override
    public final SecurityConfigurationException idmJpaStartFailed(final Throwable e) {
        final SecurityConfigurationException result = new SecurityConfigurationException(String.format(getLoggingLocale(), idmJpaStartFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idmJpaEMFLookupFailed = "WFLYPL0052: Could not lookup EntityManagerFactory [%s].";
    protected String idmJpaEMFLookupFailed$str() {
        return idmJpaEMFLookupFailed;
    }
    @Override
    public final SecurityConfigurationException idmJpaEMFLookupFailed(final String entityManagerFactoryJndiName) {
        final SecurityConfigurationException result = new SecurityConfigurationException(String.format(getLoggingLocale(), idmJpaEMFLookupFailed$str(), entityManagerFactoryJndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idmJpaFailedCreateTransactionEntityManager = "WFLYPL0053: Could not create transactional EntityManager.";
    protected String idmJpaFailedCreateTransactionEntityManager$str() {
        return idmJpaFailedCreateTransactionEntityManager;
    }
    @Override
    public final SecurityConfigurationException idmJpaFailedCreateTransactionEntityManager(final Exception e) {
        final SecurityConfigurationException result = new SecurityConfigurationException(String.format(getLoggingLocale(), idmJpaFailedCreateTransactionEntityManager$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idmNoIdentityConfigurationProvided = "WFLYPL0054: You must provide at least one identity configuration.";
    protected String idmNoIdentityConfigurationProvided$str() {
        return idmNoIdentityConfigurationProvided;
    }
    @Override
    public final OperationFailedException idmNoIdentityConfigurationProvided() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), idmNoIdentityConfigurationProvided$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idmNoIdentityStoreProvided = "WFLYPL0055: You must provide at least one identity store for identity configuration [%s].";
    protected String idmNoIdentityStoreProvided$str() {
        return idmNoIdentityStoreProvided;
    }
    @Override
    public final OperationFailedException idmNoIdentityStoreProvided(final String identityConfiguration) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), idmNoIdentityStoreProvided$str(), identityConfiguration));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idmNoSupportedTypesDefined = "WFLYPL0056: No supported type provided.";
    protected String idmNoSupportedTypesDefined$str() {
        return idmNoSupportedTypesDefined;
    }
    @Override
    public final OperationFailedException idmNoSupportedTypesDefined() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), idmNoSupportedTypesDefined$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String idmLdapNoMappingDefined = "WFLYPL0057: No mapping was defined.";
    protected String idmLdapNoMappingDefined$str() {
        return idmLdapNoMappingDefined;
    }
    @Override
    public final OperationFailedException idmLdapNoMappingDefined() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), idmLdapNoMappingDefined$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String federationIdentityProviderNotConfigured = "WFLYPL0100: No Identity Provider configuration found for federation [%s]. ";
    protected String federationIdentityProviderNotConfigured$str() {
        return federationIdentityProviderNotConfigured;
    }
    @Override
    public final IllegalStateException federationIdentityProviderNotConfigured(final String federationAlias) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), federationIdentityProviderNotConfigured$str(), federationAlias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String federationHandlerTypeNotProvided = "WFLYPL0101: No type provided for the handler. You must specify a class-name or code.";
    protected String federationHandlerTypeNotProvided$str() {
        return federationHandlerTypeNotProvided;
    }
    @Override
    public final OperationFailedException federationHandlerTypeNotProvided() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), federationHandlerTypeNotProvided$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String federationCouldNotParseSTSConfig = "WFLYPL0102: Could not parse default STS configuration.";
    protected String federationCouldNotParseSTSConfig$str() {
        return federationCouldNotParseSTSConfig;
    }
    @Override
    public final RuntimeException federationCouldNotParseSTSConfig(final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), federationCouldNotParseSTSConfig$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String federationSAMLMetadataConfigError = "WFLYPL0104: Could not configure SAML Metadata to deployment [%s].";
    protected String federationSAMLMetadataConfigError$str() {
        return federationSAMLMetadataConfigError;
    }
    @Override
    public final IllegalStateException federationSAMLMetadataConfigError(final String deploymentName, final ProcessingException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), federationSAMLMetadataConfigError$str(), deploymentName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
