/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.common.model;

import java.util.HashMap;
import java.util.Map;

public enum XMLElement {
    RELATIONSHIPS("relationships"),
    LDAP_MAPPINGS("mappings"),
    IDENTITY_STORE_CREDENTIAL_HANDLERS("credential-handlers"),
    TRUST("trust"),
    SERVICE_PROVIDERS("service-providers"),
    HANDLERS("handlers");

    private static final Map<String, XMLElement> xmlElements;
    private final String name;

    private XMLElement(String name) {
        this.name = name;
    }

    public static XMLElement forName(String name) {
        return xmlElements.get(name);
    }

    public String getName() {
        return this.name;
    }

    static {
        xmlElements = new HashMap<String, XMLElement>();
        for (XMLElement element : XMLElement.values()) {
            xmlElements.put(element.getName(), element);
        }
    }
}

