/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.wildfly.extension.picketlink.federation.model.FederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.FederationService;
import org.wildfly.extension.undertow.UndertowService;

public class FederationAddHandler
extends AbstractAddStepHandler {
    static final FederationAddHandler INSTANCE = new FederationAddHandler();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : FederationResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        this.launchServices(operation, context, verificationHandler, newControllers);
    }

    void launchServices(ModelNode operation, OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String alias = pathAddress.getLastElement().getValue();
        FederationService service = new FederationService(alias);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(FederationService.createServiceName(alias), (Service)service);
        serviceBuilder.addDependency(UndertowService.UNDERTOW);
        ServiceController controller = serviceBuilder.addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }
}

