/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.sp;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.wildfly.extension.picketlink.federation.config.SPConfiguration;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.FederationService;
import org.wildfly.extension.picketlink.federation.service.ServiceProviderService;

public class ServiceProviderAddHandler
extends AbstractAddStepHandler {
    public static final ServiceProviderAddHandler INSTANCE = new ServiceProviderAddHandler();

    private ServiceProviderAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : ServiceProviderResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceProviderAddHandler.launchService(context, PathAddress.pathAddress((ModelNode)operation.get("address")), model, verificationHandler, newControllers);
    }

    public static void launchService(OperationContext context, PathAddress pathAddress, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String alias = pathAddress.getLastElement().getValue();
        ServiceProviderService service = new ServiceProviderService(ServiceProviderAddHandler.toSPConfig(context, model, alias));
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(ServiceProviderService.createServiceName(alias), (Service)service);
        String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        serviceBuilder.addDependency(FederationService.createServiceName(federationAlias), FederationService.class, service.getFederationService());
        ServiceController controller = serviceBuilder.addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.PASSIVE).install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    private static SPConfiguration toSPConfig(OperationContext context, ModelNode fromModel, String alias) throws OperationFailedException {
        SPConfiguration spType = new SPConfiguration(alias);
        String url = ServiceProviderResourceDefinition.URL.resolveModelAttribute(context, fromModel).asString();
        spType.setServiceURL(url);
        String securityDomain = ServiceProviderResourceDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, fromModel).asString();
        spType.setSecurityDomain(securityDomain);
        boolean postBinding = ServiceProviderResourceDefinition.POST_BINDING.resolveModelAttribute(context, fromModel).asBoolean();
        spType.setPostBinding(postBinding);
        boolean supportsSignatures = ServiceProviderResourceDefinition.SUPPORT_SIGNATURES.resolveModelAttribute(context, fromModel).asBoolean();
        spType.setSupportsSignature(supportsSignatures);
        boolean supportsMetadata = ServiceProviderResourceDefinition.SUPPORT_METADATA.resolveModelAttribute(context, fromModel).asBoolean();
        spType.setSupportMetadata(supportsMetadata);
        boolean strictPostBinding = ServiceProviderResourceDefinition.STRICT_POST_BINDING.resolveModelAttribute(context, fromModel).asBoolean();
        spType.setIdpUsesPostBinding(strictPostBinding);
        String errorPage = ServiceProviderResourceDefinition.ERROR_PAGE.resolveModelAttribute(context, fromModel).asString();
        spType.setErrorPage(errorPage);
        String logoutPage = ServiceProviderResourceDefinition.LOGOUT_PAGE.resolveModelAttribute(context, fromModel).asString();
        spType.setLogOutPage(logoutPage);
        return spType;
    }
}

