/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.config.federation.STSType;
import org.wildfly.extension.picketlink.federation.service.FederationService;

public class SAMLService
implements Service<SAMLService> {
    private static final String SERVICE_NAME = "SAMLService";
    private final STSType stsType;
    private final InjectedValue<FederationService> federationService = new InjectedValue();

    public SAMLService(STSType stsType) {
        this.stsType = stsType;
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, alias});
    }

    public SAMLService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ((FederationService)this.getFederationService().getValue()).setSTSType(this.stsType);
    }

    public void stop(StopContext context) {
        ((FederationService)this.getFederationService().getValue()).setSTSType(null);
    }

    public InjectedValue<FederationService> getFederationService() {
        return this.federationService;
    }
}

