/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.picketlink.federation.service.FederationService;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;

public class TrustDomainService
implements Service<TrustDomainService> {
    private static final String SERVICE_NAME = "TrustDomainService";
    private final String domainCertAlias;
    private final String domainName;
    private final InjectedValue<IdentityProviderService> identityProviderService = new InjectedValue();
    private final InjectedValue<FederationService> federationService = new InjectedValue();

    public TrustDomainService(String domainName, String domainCertAlias) {
        this.domainName = domainName;
        this.domainCertAlias = domainCertAlias;
    }

    public static ServiceName createServiceName(String federationAlias, String domainName) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, federationAlias + "." + domainName});
    }

    public TrustDomainService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ((FederationService)this.getFederationService().getValue()).addTrustedDomain(this.domainName, this.domainCertAlias);
    }

    public void stop(StopContext context) {
        ((FederationService)this.getFederationService().getValue()).removeTrustedDomain(this.domainName);
    }

    public InjectedValue<IdentityProviderService> getIdentityProviderService() {
        return this.identityProviderService;
    }

    public InjectedValue<FederationService> getFederationService() {
        return this.federationService;
    }
}

