/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerAddHandler;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerRemoveHandler;
import org.wildfly.extension.picketlink.idm.service.PartitionManagerService;

public class IDMConfigRemoveStepHandler
extends RestartParentResourceRemoveHandler {
    static final IDMConfigRemoveStepHandler INSTANCE = new IDMConfigRemoveStepHandler();

    private IDMConfigRemoveStepHandler() {
        super(ModelElement.PARTITION_MANAGER.getName());
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        final PathAddress address = this.getParentAddress(PathAddress.pathAddress((ModelNode)operation.require("address")));
        Resource resource = context.readResourceFromRoot(address);
        final ModelNode parentModel = Resource.Tools.readModel((Resource)resource);
        super.updateModel(context, operation);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PartitionManagerRemoveHandler.INSTANCE.removeIdentityStoreServices(context, parentModel, address.getLastElement().getValue());
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        context.completeStep(NOOP_ROLLBACK_HANDLER);
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PartitionManagerAddHandler.INSTANCE.createPartitionManagerService(context, parentAddress.getLastElement().getValue(), parentModel, verificationHandler, null);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return PartitionManagerService.createServiceName(parentAddress.getLastElement().getValue());
    }
}

