/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.io.Serializable;
import org.jboss.as.pojo.descriptor.AbstractConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public class ModuleConfig
extends AbstractConfigVisitorNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String moduleName;
    private final InjectedValue<Module> injectedModule = new InjectedValue();

    @Override
    public void visit(ConfigVisitor visitor) {
        if (this.moduleName != null) {
            ModuleIdentifier identifier = ModuleIdentifier.fromString((String)this.moduleName);
            if (this.moduleName.startsWith("deployment.")) {
                ServiceName serviceName = ServiceModuleLoader.moduleServiceName((ModuleIdentifier)identifier);
                visitor.addDependency(serviceName, (Injector)this.getInjectedModule());
            } else {
                Module dm = visitor.loadModule(identifier);
                this.getInjectedModule().setValue(() -> dm);
            }
        } else {
            this.getInjectedModule().setValue(() -> visitor.getModule());
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public InjectedValue<Module> getInjectedModule() {
        return this.injectedModule;
    }
}

