/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;

public final class SingleKeyNonTxInvocationContext
implements InvocationContext {
    private boolean isLocked;
    private Object key;
    private CacheEntry cacheEntry;
    private final Address origin;
    private Object lockOwner;

    public SingleKeyNonTxInvocationContext(Address origin) {
        this.origin = origin;
    }

    @Override
    public boolean isOriginLocal() {
        return this.origin == null;
    }

    @Override
    public boolean isInTxScope() {
        return false;
    }

    @Override
    public Object getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public void setLockOwner(Object lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public InvocationContext clone() {
        try {
            return (InvocationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!", e);
        }
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.isLocked ? Collections.singleton(this.key) : Collections.emptySet();
    }

    @Override
    public void clearLockedKeys() {
        this.isLocked = false;
    }

    @Override
    public void addLockedKey(Object key) {
        if (this.key == null) {
            this.key = key;
        } else if (!this.isKeyEquals(key)) {
            throw this.illegalStateException();
        }
        this.isLocked = true;
    }

    private IllegalStateException illegalStateException() {
        return new IllegalStateException("This is a single key invocation context, using multiple keys shouldn't be possible");
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (this.key != null && this.isKeyEquals(key)) {
            return this.cacheEntry;
        }
        return null;
    }

    public boolean isKeyEquals(Object key) {
        return this.key == key || this.key.equals(key);
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.cacheEntry == null ? Collections.emptyMap() : Collections.singletonMap(this.key, this.cacheEntry);
    }

    @Override
    public void forEachEntry(BiConsumer<Object, CacheEntry> action) {
        if (this.cacheEntry != null) {
            action.accept(this.key, this.cacheEntry);
        }
    }

    @Override
    public int lookedUpEntriesCount() {
        return this.cacheEntry != null ? 1 : 0;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.key == null) {
            this.key = key;
        } else if (!this.isKeyEquals(key)) {
            throw this.illegalStateException();
        }
        this.cacheEntry = e;
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.key != null && this.isKeyEquals(key)) {
            this.cacheEntry = null;
        }
    }

    public Object getKey() {
        return this.key;
    }

    public CacheEntry getCacheEntry() {
        return this.cacheEntry;
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.isLocked && this.isKeyEquals(key);
    }

    @Override
    public boolean isEntryRemovedInContext(Object key) {
        CacheEntry ce = this.lookupEntry(key);
        return ce != null && ce.isRemoved() && ce.isChanged();
    }

    public void resetState() {
        this.key = null;
        this.cacheEntry = null;
        this.isLocked = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SingleKeyNonTxInvocationContext{");
        sb.append("isLocked=").append(this.isLocked);
        sb.append(", key=").append(this.key);
        sb.append(", cacheEntry=").append(this.cacheEntry);
        sb.append(", origin=").append(this.origin);
        sb.append(", lockOwner=").append(this.lockOwner);
        sb.append('}');
        return sb.toString();
    }
}

