/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;

public class IracResponseCollector
extends CompletableFuture<Result>
implements BiConsumer<Void, Throwable> {
    private static final Log log = LogFactory.getLog(IracResponseCollector.class);
    private static final boolean trace = log.isTraceEnabled();
    @GuardedBy(value="this")
    private Result result = Result.OK;
    @GuardedBy(value="this")
    private int missing;
    @GuardedBy(value="this")
    private boolean frozen = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dependsOn(CompletionStage<Void> request) {
        IracResponseCollector iracResponseCollector = this;
        synchronized (iracResponseCollector) {
            ++this.missing;
        }
        request.whenComplete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IracResponseCollector freeze() {
        Result completeResult = null;
        IracResponseCollector iracResponseCollector = this;
        synchronized (iracResponseCollector) {
            this.frozen = true;
            if (this.missing == 0) {
                completeResult = this.result;
            }
            if (trace) {
                log.tracef("Freeze collector. result=%s, missing=%s", (Object)this.result, this.missing);
            }
        }
        this.tryComplete(completeResult);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Void aVoid, Throwable throwable) {
        Result completeResult = null;
        IracResponseCollector iracResponseCollector = this;
        synchronized (iracResponseCollector) {
            Result old = this.result;
            if (throwable != null) {
                if (DefaultTakeOfflineManager.isCommunicationError(throwable)) {
                    this.result = Result.NETWORK_EXCEPTION;
                } else {
                    Result result = this.result = this.result == Result.OK ? Result.REMOTE_EXCEPTION : this.result;
                }
            }
            if (--this.missing == 0 && this.frozen) {
                completeResult = this.result;
            }
            if (trace) {
                log.tracef("Receive response. old=%s, new=%s, missing=%s", (Object)old, (Object)this.result, this.missing);
            }
        }
        this.tryComplete(completeResult);
    }

    private void tryComplete(Result result) {
        if (result == null) {
            return;
        }
        if (trace) {
            log.tracef("All response received: %s", (Object)result);
        }
        this.complete(result);
    }

    static enum Result {
        OK,
        REMOTE_EXCEPTION,
        NETWORK_EXCEPTION;

    }
}

