/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.server.parsing.DeploymentOverlaysXml;
import org.jboss.as.server.parsing.DeploymentsXml;
import org.jboss.as.server.parsing.InterfacesXml;
import org.jboss.as.server.parsing.PathsXml;
import org.jboss.as.server.parsing.SocketBindingsXml;
import org.jboss.as.server.parsing.SystemPropertiesXml;
import org.jboss.as.server.parsing.VaultXml;
import org.jboss.as.server.services.net.SocketBindingGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class CommonXml
implements XMLElementReader<List<ModelNode>> {
    private final DeploymentOverlaysXml deploymentOverlaysXml = new DeploymentOverlaysXml();
    private final DeploymentsXml deploymentsXml = new DeploymentsXml();
    private final InterfacesXml interfacesXml = new InterfacesXml();
    private final PathsXml pathsXml = new PathsXml();
    private final SocketBindingsXml socketBindingsXml;
    private final SystemPropertiesXml systemPropertiesXml = new SystemPropertiesXml();
    private final VaultXml vaultXml = new VaultXml();

    protected CommonXml(SocketBindingsXml socketBindingsXml) {
        this.socketBindingsXml = socketBindingsXml;
    }

    @Deprecated
    protected CommonXml() {
        this.socketBindingsXml = new SocketBindingsXml(){

            @Override
            protected void writeExtraAttributes(XMLExtendedStreamWriter writer, ModelNode bindingGroup) throws XMLStreamException {
                SocketBindingGroupResourceDefinition.PORT_OFFSET.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
            }
        };
    }

    protected void parseNamespaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> nodes) {
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null || prefix.length() <= 0) continue;
            nodes.add(NamespaceAddHandler.getAddNamespaceOperation((ModelNode)address, (String)prefix, (String)reader.getNamespaceURI(i)));
        }
    }

    protected void parseSchemaLocations(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updateList, int idx) throws XMLStreamException {
        List elements = reader.getListAttributeValue(idx);
        ArrayList<String> values = new ArrayList<String>();
        for (String element : elements) {
            if (element.trim().isEmpty()) continue;
            values.add(element);
        }
        if ((values.size() & 1) != 0) {
            throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)idx);
        }
        Iterator it = values.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String val = (String)it.next();
            if (key.length() <= 0 || val.length() <= 0) continue;
            updateList.add(SchemaLocationAddHandler.getAddSchemaLocationOperation((ModelNode)address, (String)key, (String)val));
        }
    }

    protected void writeSchemaLocation(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (!modelNode.hasDefined("schema-locations")) {
            return;
        }
        StringBuilder b = new StringBuilder();
        Iterator iterator = modelNode.get("schema-locations").asList().iterator();
        while (iterator.hasNext()) {
            ModelNode location = (ModelNode)iterator.next();
            Property property = location.asProperty();
            b.append(property.getName()).append(' ').append(property.getValue().asString());
            if (!iterator.hasNext()) continue;
            b.append(' ');
        }
        if (b.length() > 0) {
            writer.writeAttribute(Namespace.XML_SCHEMA_INSTANCE.getUriString(), Attribute.SCHEMA_LOCATION.getLocalName(), b.toString());
        }
    }

    protected void writeNamespaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        boolean needXsd = modelNode.hasDefined("schema-locations") && modelNode.get("schema-locations").asInt() > 0;
        boolean hasNamespaces = modelNode.hasDefined("namespaces");
        if (!needXsd && !hasNamespaces) {
            return;
        }
        boolean wroteXsd = false;
        String xsdUri = Namespace.XML_SCHEMA_INSTANCE.getUriString();
        if (hasNamespaces) {
            for (Property property : modelNode.get("namespaces").asPropertyList()) {
                String uri = property.getValue().asString();
                writer.writeNamespace(property.getName(), uri);
                if (wroteXsd || !xsdUri.equals(uri)) continue;
                wroteXsd = true;
            }
        }
        if (needXsd && !wroteXsd) {
            writer.writeNamespace("xsd", xsdUri);
        }
    }

    @Deprecated
    protected static void writeElement(XMLExtendedStreamWriter writer, Element element) throws XMLStreamException {
        WriteUtils.writeElement((XMLExtendedStreamWriter)writer, (Element)element);
    }

    protected void writePaths(XMLExtendedStreamWriter writer, ModelNode node, boolean namedPath) throws XMLStreamException {
        this.pathsXml.writePaths(writer, node, namedPath);
    }

    protected void parsePaths(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean requirePath) throws XMLStreamException {
        this.pathsXml.parsePaths(reader, address, expectedNs, list, requirePath);
    }

    protected void parseSystemProperties(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> updates, boolean standalone) throws XMLStreamException {
        this.systemPropertiesXml.parseSystemProperties(reader, address, expectedNs, updates, standalone);
    }

    protected void parseInterfaces(XMLExtendedStreamReader reader, Set<String> names, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean checkSpecified) throws XMLStreamException {
        this.interfacesXml.parseInterfaces(reader, names, address, expectedNs, list, checkSpecified);
    }

    protected void parseSocketBindingGroupRef(XMLExtendedStreamReader reader, ModelNode addOperation, SimpleAttributeDefinition socketBindingGroup, SimpleAttributeDefinition portOffset, SimpleAttributeDefinition defaultInterface) throws XMLStreamException {
        this.socketBindingsXml.parseSocketBindingGroupRef(reader, addOperation, socketBindingGroup, portOffset, defaultInterface);
    }

    protected String parseSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        return this.socketBindingsXml.parseSocketBinding(reader, interfaces, address, updates);
    }

    protected String parseOutboundSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        return this.socketBindingsXml.parseOutboundSocketBinding(reader, interfaces, address, updates);
    }

    public void parseDeployments(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, Set<Attribute> allowedAttributes, Set<Element> allowedElements, boolean validateUniqueRuntimeNames) throws XMLStreamException {
        this.deploymentsXml.parseDeployments(reader, address, expectedNs, list, allowedAttributes, allowedElements, validateUniqueRuntimeNames);
    }

    protected void parseDeploymentOverlays(XMLExtendedStreamReader reader, Namespace namespace, ModelNode baseAddress, List<ModelNode> list, boolean allowContent, boolean allowDeployment) throws XMLStreamException {
        this.deploymentOverlaysXml.parseDeploymentOverlays(reader, namespace, baseAddress, list, allowContent, allowDeployment);
    }

    protected void parseVault(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        this.vaultXml.parseVault(reader, address, expectedNs, list);
    }

    protected void writeInterfaces(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        this.interfacesXml.writeInterfaces(writer, modelNode);
    }

    protected void writeSocketBindingGroup(XMLExtendedStreamWriter writer, ModelNode bindingGroup, String name) throws XMLStreamException {
        this.socketBindingsXml.writeSocketBindingGroup(writer, bindingGroup, name);
    }

    protected void writeProperties(XMLExtendedStreamWriter writer, ModelNode modelNode, Element element, boolean standalone) throws XMLStreamException {
        this.systemPropertiesXml.writeProperties(writer, modelNode, element, standalone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeSubsystems(ModelNode profileNode, XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        AbstractSet subsystemNames;
        if (profileNode.hasDefined("subsystem") && !(subsystemNames = profileNode.get("subsystem").keys()).isEmpty()) {
            TreeSet alphabetical = new TreeSet(subsystemNames);
            if (alphabetical.contains("logging")) {
                subsystemNames = new LinkedHashSet();
                subsystemNames.add("logging");
                subsystemNames.addAll(alphabetical);
            } else {
                subsystemNames = alphabetical;
            }
            String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
            for (String subsystemName : subsystemNames) {
                try {
                    ModelNode subsystem = profileNode.get(new String[]{"subsystem", subsystemName});
                    XMLElementWriter subsystemWriter = context.getSubsystemWriter(subsystemName);
                    if (subsystemWriter == null) continue;
                    subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
                }
                finally {
                    writer.setDefaultNamespace(defaultNamespace);
                }
            }
        }
    }

    @Deprecated
    protected static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attribute, String value) throws XMLStreamException {
        WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)attribute, (String)value);
    }

    protected static void writeContentItem(XMLExtendedStreamWriter writer, ModelNode contentItem) throws XMLStreamException {
        DeploymentsXml.writeContentItem(writer, contentItem);
    }

    @Deprecated
    protected static void writeNewLine(XMLExtendedStreamWriter writer) throws XMLStreamException {
        WriteUtils.writeNewLine((XMLExtendedStreamWriter)writer);
    }

    protected void writeDeploymentOverlays(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        this.deploymentOverlaysXml.writeDeploymentOverlays(writer, modelNode);
    }
}

