/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Timer;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.persist.ConditionalLoadXMLObjectLoadSaveManager;
import org.opensaml.core.xml.persist.XMLObjectLoadSaveManager;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DefaultLocalDynamicSourceKeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDynamicMetadataResolver
extends AbstractDynamicMetadataResolver {
    private Logger log = LoggerFactory.getLogger(LocalDynamicMetadataResolver.class);
    @Nonnull
    private XMLObjectLoadSaveManager<XMLObject> sourceManager;
    @Nonnull
    private Function<CriteriaSet, String> sourceKeyGenerator;

    public LocalDynamicMetadataResolver(@Nonnull XMLObjectLoadSaveManager<XMLObject> manager) {
        this(null, manager, null);
    }

    public LocalDynamicMetadataResolver(@Nonnull XMLObjectLoadSaveManager<XMLObject> manager, @Nullable Function<CriteriaSet, String> keyGenerator) {
        this(null, manager, keyGenerator);
    }

    public LocalDynamicMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull XMLObjectLoadSaveManager<XMLObject> manager, @Nullable Function<CriteriaSet, String> keyGenerator) {
        super(backgroundTaskTimer);
        this.sourceManager = (XMLObjectLoadSaveManager)Constraint.isNotNull(manager, (String)"Local source manager was null");
        this.sourceKeyGenerator = keyGenerator;
        if (this.sourceKeyGenerator == null) {
            this.sourceKeyGenerator = new DefaultLocalDynamicSourceKeyGenerator();
        }
    }

    @Override
    protected void removeByEntityID(String entityID, AbstractMetadataResolver.EntityBackingStore backingStore) {
        String key;
        if (this.sourceManager instanceof ConditionalLoadXMLObjectLoadSaveManager && (key = (String)this.sourceKeyGenerator.apply((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)}))) != null) {
            ((ConditionalLoadXMLObjectLoadSaveManager)this.sourceManager).clearLoadLastModified(key);
        }
        super.removeByEntityID(entityID, backingStore);
    }

    @Override
    protected XMLObject fetchFromOriginSource(CriteriaSet criteria) throws IOException {
        String key = (String)this.sourceKeyGenerator.apply((Object)criteria);
        if (key != null) {
            this.log.trace("{} Attempting to load from local source manager with generated key '{}'", (Object)this.getLogPrefix(), (Object)key);
            XMLObject result = this.sourceManager.load(key);
            if (result != null) {
                this.log.trace("{} Successfully loaded target from local source manager source with key '{}' of type: {}", new Object[]{this.getLogPrefix(), key, result.getElementQName()});
            } else {
                this.log.trace("{} Found no target in local source manager with key '{}'", (Object)this.getLogPrefix(), (Object)key);
            }
            return result;
        }
        this.log.trace("{} Could not generate source key from criteria, can not resolve", (Object)this.getLogPrefix());
        return null;
    }
}

