/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.ArrayType;
import org.apache.cxf.aegis.type.basic.ObjectType;
import org.apache.cxf.aegis.type.collection.CollectionType;
import org.apache.cxf.aegis.type.collection.MapType;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.aegis.util.ServiceUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.ws.commons.schema.constants.Constants;

public abstract class AbstractTypeCreator
implements TypeCreator {
    public static final String HTTP_CXF_APACHE_ORG_ARRAYS = "http://cxf.apache.org/arrays";
    protected TypeMapping tm;
    protected AbstractTypeCreator nextCreator;
    private TypeCreationOptions typeConfiguration;
    private TypeCreator parent;

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public TypeCreator getTopCreator() {
        AbstractTypeCreator top;
        TypeCreator next = top = this;
        while (next != null) {
            top = next;
            next = top.getParent();
        }
        return top;
    }

    @Override
    public TypeCreator getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TypeCreator parent) {
        this.parent = parent;
    }

    @Override
    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
        if (this.nextCreator != null) {
            this.nextCreator.setTypeMapping(this.tm);
        }
    }

    public void setNextCreator(AbstractTypeCreator creator) {
        this.nextCreator = creator;
        this.nextCreator.parent = this;
    }

    public TypeClassInfo createClassInfo(Field f) {
        TypeClassInfo info = this.createBasicClassInfo(f.getType());
        info.setDescription("field " + f.getName() + " in  " + f.getDeclaringClass());
        return info;
    }

    @Override
    public TypeClassInfo createBasicClassInfo(Type type) {
        TypeClassInfo info = new TypeClassInfo();
        Class<?> typeClass = TypeUtil.getTypeClass(type, false);
        if (typeClass != null) {
            info.setDescription("class '" + typeClass.getName() + "'");
        } else {
            info.setDescription("type '" + type + "'");
        }
        info.setType(type);
        return info;
    }

    @Override
    public AegisType createTypeForClass(TypeClassInfo info) {
        Class<?> javaClass = TypeUtil.getTypeRelatedClass(info.getType());
        AegisType result = null;
        boolean newType = true;
        if (info.getType() instanceof TypeVariable) {
            result = this.getOrCreateGenericType(info);
        } else if (info.getAegisTypeClass() != null) {
            result = this.createUserType(info);
        } else if (this.isArray(javaClass)) {
            result = this.createArrayType(info);
        } else if (this.isMap(javaClass)) {
            result = this.createMapType(info);
        } else if (this.isHolder(javaClass)) {
            result = this.createHolderType(info);
        } else if (this.isCollection(javaClass)) {
            result = this.createCollectionType(info);
        } else if (this.isEnum(javaClass)) {
            result = this.createEnumType(info);
        } else if (javaClass.equals(byte[].class)) {
            result = this.getTypeMapping().getType(javaClass);
        } else {
            AegisType type = this.getTypeMapping().getType(info.getType());
            if (type == null || info.getTypeName() != null && !type.getSchemaType().equals(info.getTypeName())) {
                if (info.getTypeName() != null) {
                    type = this.getTypeMapping().getType(info.getTypeName());
                }
                if (type == null) {
                    type = this.getTypeMapping().getType(javaClass);
                }
                if (type == null) {
                    type = this.createDefaultType(info);
                } else {
                    newType = false;
                }
            } else {
                newType = false;
            }
            result = type;
        }
        if (newType && !this.getConfiguration().isDefaultNillable()) {
            result.setNillable(false);
        }
        return result;
    }

    protected boolean isHolder(Class<?> javaType) {
        return "jakarta.xml.ws.Holder".equals(javaType.getName());
    }

    protected AegisType createHolderType(TypeClassInfo info) {
        Type heldType = TypeUtil.getSingleTypeParameter(info.getType(), 0);
        if (heldType == null) {
            throw new UnsupportedOperationException("Invalid holder type " + info.getType());
        }
        info.setType(heldType);
        return this.createType(heldType);
    }

    protected boolean isArray(Class<?> javaType) {
        return javaType.isArray() && !javaType.equals(byte[].class);
    }

    protected AegisType createUserType(TypeClassInfo info) {
        try {
            AegisType type = info.getAegisTypeClass().newInstance();
            QName name = info.getTypeName();
            if (name == null) {
                Class<?> typeClass = TypeUtil.getTypeRelatedClass(info.getType());
                if (typeClass.getPackage().getName().startsWith("java")) {
                    name = this.tm.getTypeQName(typeClass);
                }
                if (name == null) {
                    name = this.createQName(typeClass);
                }
            }
            type.setSchemaType(name);
            type.setTypeClass(info.getType());
            type.setTypeMapping(this.getTypeMapping());
            return type;
        }
        catch (InstantiationException e) {
            throw new DatabindingException("Couldn't instantiate type classs " + info.getAegisTypeClass().getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DatabindingException("Couldn't access type classs " + info.getAegisTypeClass().getName(), (Throwable)e);
        }
    }

    protected AegisType createArrayType(TypeClassInfo info) {
        ArrayType type = new ArrayType();
        type.setTypeMapping(this.getTypeMapping());
        type.setTypeClass(info.getType());
        type.setSchemaType(this.createCollectionQName(info, type.getComponentType()));
        if (info.getMinOccurs() != -1L) {
            type.setMinOccurs(info.getMinOccurs());
        } else {
            type.setMinOccurs(this.typeConfiguration.getDefaultMinOccurs());
        }
        if (info.getMaxOccurs() != -1L) {
            type.setMaxOccurs(info.getMaxOccurs());
        }
        type.setFlat(info.isFlat());
        return type;
    }

    protected QName createQName(Class<?> javaType) {
        String clsName = javaType.getName();
        String ns = NamespaceHelper.makeNamespaceFromClassName(clsName, "http");
        String localName = ServiceUtils.makeServiceNameFromClassName(javaType);
        return new QName(ns, localName);
    }

    protected boolean isCollection(Class<?> javaType) {
        return Collection.class.isAssignableFrom(javaType);
    }

    protected AegisType createCollectionTypeFromGeneric(TypeClassInfo info) {
        AegisType component = this.getOrCreateGenericType(info);
        CollectionType type = new CollectionType(component);
        type.setTypeMapping(this.getTypeMapping());
        QName name = info.getTypeName();
        if (name == null) {
            name = this.createCollectionQName(info, component);
        }
        type.setSchemaType(name);
        type.setTypeClass(info.getType());
        if (info.getMinOccurs() != -1L) {
            type.setMinOccurs(info.getMinOccurs());
        }
        if (info.getMaxOccurs() != -1L) {
            type.setMaxOccurs(info.getMaxOccurs());
        }
        type.setFlat(info.isFlat());
        return type;
    }

    protected AegisType getOrCreateGenericType(TypeClassInfo info) {
        return this.createObjectType();
    }

    protected AegisType getOrCreateMapKeyType(TypeClassInfo info) {
        return this.nextCreator.getOrCreateMapKeyType(info);
    }

    protected AegisType createObjectType() {
        ObjectType type = new ObjectType();
        type.setSchemaType(Constants.XSD_ANYTYPE);
        type.setTypeClass((Type)((Object)Object.class));
        type.setTypeMapping(this.getTypeMapping());
        return type;
    }

    protected AegisType getOrCreateMapValueType(TypeClassInfo info) {
        return this.nextCreator.getOrCreateMapValueType(info);
    }

    protected AegisType createMapType(TypeClassInfo info, AegisType keyType, AegisType valueType) {
        QName schemaType = this.createMapQName(info, keyType, valueType);
        MapType type = new MapType(schemaType, keyType, valueType);
        type.setTypeMapping(this.getTypeMapping());
        type.setTypeClass(info.getType());
        return type;
    }

    protected AegisType createMapType(TypeClassInfo info) {
        AegisType keyType = this.getOrCreateMapKeyType(info);
        AegisType valueType = this.getOrCreateMapValueType(info);
        return this.createMapType(info, keyType, valueType);
    }

    protected QName createMapQName(TypeClassInfo info, AegisType keyType, AegisType valueType) {
        String name = keyType.getSchemaType().getLocalPart() + '2' + valueType.getSchemaType().getLocalPart();
        Class<?> cls = TypeUtil.getTypeRelatedClass(info.getType());
        name = name + cls.getSimpleName();
        return new QName(this.tm.getMappingIdentifierURI(), name);
    }

    protected boolean isMap(Class<?> javaType) {
        return Map.class.isAssignableFrom(javaType);
    }

    public abstract TypeClassInfo createClassInfo(PropertyDescriptor var1);

    protected boolean isEnum(Class<?> javaType) {
        return false;
    }

    public AegisType createEnumType(TypeClassInfo info) {
        return null;
    }

    public abstract AegisType createCollectionType(TypeClassInfo var1);

    public abstract AegisType createDefaultType(TypeClassInfo var1);

    protected QName createCollectionQName(TypeClassInfo info, AegisType type) {
        String ns = type.isComplex() ? type.getSchemaType().getNamespaceURI() : this.tm.getMappingIdentifierURI();
        if ("http://www.w3.org/2001/XMLSchema".equals(ns)) {
            ns = HTTP_CXF_APACHE_ORG_ARRAYS;
        }
        String localName = "ArrayOf" + StringUtils.capitalize((String)type.getSchemaType().getLocalPart());
        if (info.nonDefaultAttributes()) {
            localName = localName + "-";
            if (info.getMinOccurs() >= 0L) {
                localName = localName + info.getMinOccurs();
            }
            localName = localName + "-";
            if (info.getMaxOccurs() >= 0L) {
                localName = localName + info.getMaxOccurs();
            }
            if (info.isFlat()) {
                localName = localName + "Flat";
            }
        }
        return new QName(ns, localName);
    }

    @Override
    public abstract TypeClassInfo createClassInfo(Method var1, int var2);

    @Override
    public AegisType createType(Method m, int index) {
        TypeClassInfo info = this.createClassInfo(m, index);
        info.setDescription((index == -1 ? "return type" : "parameter " + index) + " of method " + m.getName() + " in " + m.getDeclaringClass());
        return this.createTypeForClass(info);
    }

    @Override
    public QName getElementName(Method m, int index) {
        TypeClassInfo info = this.createClassInfo(m, index);
        return info.getMappedName();
    }

    @Override
    public AegisType createType(PropertyDescriptor pd) {
        TypeClassInfo info = this.createClassInfo(pd);
        info.setDescription("property " + pd.getName());
        return this.createTypeForClass(info);
    }

    @Override
    public AegisType createType(Field f) {
        TypeClassInfo info = this.createClassInfo(f);
        info.setDescription("field " + f.getName() + " in " + f.getDeclaringClass());
        return this.createTypeForClass(info);
    }

    @Override
    public AegisType createType(Type t) {
        TypeClassInfo info = new TypeClassInfo();
        info.setType(t);
        info.setDescription("reflected type " + t.toString());
        return this.createTypeForClass(info);
    }

    public AegisType createType(Class<?> clazz) {
        TypeClassInfo info = this.createBasicClassInfo(clazz);
        info.setDescription(clazz.toString());
        return this.createTypeForClass(info);
    }

    public TypeCreationOptions getConfiguration() {
        return this.typeConfiguration;
    }

    public void setConfiguration(TypeCreationOptions tpConfiguration) {
        this.typeConfiguration = tpConfiguration;
    }
}

