/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms;

import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AutoApplySession;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import org.glassfish.soteria.mechanisms.LoginToContinueHolder;

@AutoApplySession
@LoginToContinue
@Typed(value={CustomFormAuthenticationMechanism.class})
public class CustomFormAuthenticationMechanism
implements HttpAuthenticationMechanism,
LoginToContinueHolder {
    private LoginToContinue loginToContinue;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        if (CustomFormAuthenticationMechanism.hasCredential(httpMessageContext)) {
            IdentityStoreHandler identityStoreHandler = (IdentityStoreHandler)CDI.current().select(IdentityStoreHandler.class, new Annotation[0]).get();
            return httpMessageContext.notifyContainerAboutLogin(identityStoreHandler.validate(httpMessageContext.getAuthParameters().getCredential()));
        }
        return httpMessageContext.doNothing();
    }

    private static boolean hasCredential(HttpMessageContext httpMessageContext) {
        return httpMessageContext.getAuthParameters().getCredential() != null;
    }

    @Override
    public LoginToContinue getLoginToContinue() {
        return this.loginToContinue;
    }

    public void setLoginToContinue(LoginToContinue loginToContinue) {
        this.loginToContinue = loginToContinue;
    }

    public CustomFormAuthenticationMechanism loginToContinue(LoginToContinue loginToContinue) {
        this.setLoginToContinue(loginToContinue);
        return this;
    }
}

