/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms;

import jakarta.security.auth.message.MessageInfo;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.mechanisms.jaspic.Jaspic;

public class HttpMessageContextImpl
implements HttpMessageContext {
    private CallbackHandler handler;
    private MessageInfo messageInfo;
    private Subject clientSubject;
    private AuthenticationParameters authParameters;
    private Principal callerPrincipal;
    private Set<String> groups;

    public HttpMessageContextImpl(CallbackHandler handler, MessageInfo messageInfo, Subject clientSubject) {
        this.handler = handler;
        this.messageInfo = messageInfo;
        this.clientSubject = clientSubject;
        if (messageInfo != null) {
            this.authParameters = Jaspic.getAuthParameters(this.getRequest());
        }
    }

    public boolean isProtected() {
        return Jaspic.isProtectedResource(this.messageInfo);
    }

    public boolean isAuthenticationRequest() {
        return Jaspic.isAuthenticationRequest(this.getRequest());
    }

    public boolean isRegisterSession() {
        return Jaspic.isRegisterSession(this.messageInfo);
    }

    public void setRegisterSession(String username, Set<String> groups) {
        Jaspic.setRegisterSession(this.messageInfo, username, groups);
    }

    public void cleanClientSubject() {
        Jaspic.cleanSubject(this.clientSubject);
    }

    public AuthenticationParameters getAuthParameters() {
        return this.authParameters;
    }

    public CallbackHandler getHandler() {
        return this.handler;
    }

    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public Subject getClientSubject() {
        return this.clientSubject;
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.messageInfo.getRequestMessage();
    }

    public void setRequest(HttpServletRequest request) {
        this.messageInfo.setRequestMessage((Object)request);
    }

    public HttpMessageContext withRequest(HttpServletRequest request) {
        this.setRequest(request);
        return this;
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)this.messageInfo.getResponseMessage();
    }

    public void setResponse(HttpServletResponse response) {
        this.messageInfo.setResponseMessage((Object)response);
    }

    public AuthenticationStatus redirect(String location) {
        Utils.redirect(this.getResponse(), location);
        return AuthenticationStatus.SEND_CONTINUE;
    }

    public AuthenticationStatus forward(String path) {
        try {
            this.getRequest().getRequestDispatcher(path).forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        }
        catch (ServletException | IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_CONTINUE;
    }

    public AuthenticationStatus responseUnauthorized() {
        try {
            this.getResponse().sendError(401);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_FAILURE;
    }

    public AuthenticationStatus responseNotFound() {
        try {
            this.getResponse().sendError(404);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_FAILURE;
    }

    public AuthenticationStatus notifyContainerAboutLogin(String callerName, Set<String> groups) {
        NameHolderPrincipal nameHolder = null;
        if (callerName != null) {
            nameHolder = new NameHolderPrincipal(callerName);
        }
        return this.notifyContainerAboutLogin((Principal)((Object)nameHolder), groups);
    }

    public AuthenticationStatus notifyContainerAboutLogin(CredentialValidationResult result) {
        if (result.getStatus() == CredentialValidationResult.Status.VALID) {
            return this.notifyContainerAboutLogin((Principal)result.getCallerPrincipal(), (Set<String>)result.getCallerGroups());
        }
        return AuthenticationStatus.SEND_FAILURE;
    }

    public AuthenticationStatus notifyContainerAboutLogin(Principal callerPrincipal, Set<String> groups) {
        this.callerPrincipal = callerPrincipal;
        this.groups = callerPrincipal != null ? groups : null;
        if (this.callerPrincipal instanceof NameHolderPrincipal) {
            Jaspic.notifyContainerAboutLogin(this.clientSubject, this.handler, this.callerPrincipal.getName(), this.groups);
        } else {
            Jaspic.notifyContainerAboutLogin(this.clientSubject, this.handler, this.callerPrincipal, this.groups);
        }
        Jaspic.setDidAuthentication((HttpServletRequest)this.messageInfo.getRequestMessage());
        return AuthenticationStatus.SUCCESS;
    }

    public AuthenticationStatus doNothing() {
        this.callerPrincipal = null;
        this.groups = null;
        Jaspic.notifyContainerAboutLogin(this.clientSubject, this.handler, (String)null, null);
        return AuthenticationStatus.NOT_DONE;
    }

    public Principal getCallerPrincipal() {
        return this.callerPrincipal;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    private static class NameHolderPrincipal
    extends CallerPrincipal {
        NameHolderPrincipal(String name) {
            super(name);
        }
    }
}

