/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.addressing;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TwoWaysRemoveAddressTest
extends ActiveMQTestBase {
    private static Logger logger = Logger.getLogger(TwoWaysRemoveAddressTest.class);

    @Test(timeout=60000L)
    public void testDeadLock() throws Throwable {
        final ActiveMQServer server = this.addServer(this.createServer(false));
        server.start();
        int retries = 10;
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final AtomicInteger errors = new AtomicInteger(0);
        Thread createAndDestroy1 = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await(10L, TimeUnit.SECONDS);
                    for (int i = 0; i < 10; ++i) {
                        logger.debug((Object)("Removed queue on thread 1 ::" + i));
                        server.createQueue(new QueueConfiguration("queueName_1_" + i).setAddress("address_1_" + i).setRoutingType(RoutingType.ANYCAST));
                        server.destroyQueue(SimpleString.toSimpleString((String)("queueName_1_" + i)));
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)e.getMessage(), e);
                    errors.incrementAndGet();
                }
            }
        };
        Thread createAndDestroy2 = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await(10L, TimeUnit.SECONDS);
                    for (int i = 0; i < 10; ++i) {
                        logger.debug((Object)("Removed queue on thread 2 ::" + i));
                        server.createQueue(new QueueConfiguration("queueName_2_" + i).setAddress("address_2_" + i).setRoutingType(RoutingType.ANYCAST));
                        server.removeAddressInfo(SimpleString.toSimpleString((String)("address_2_" + i)), null, true);
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)e.getMessage(), e);
                    errors.incrementAndGet();
                }
            }
        };
        createAndDestroy1.start();
        createAndDestroy2.start();
        createAndDestroy1.join(10000L);
        createAndDestroy2.join(10000L);
        Assert.assertFalse((boolean)createAndDestroy1.isAlive());
        Assert.assertFalse((boolean)createAndDestroy2.isAlive());
        Assert.assertEquals((long)0L, (long)errors.get());
    }
}

