/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.junit.Before;
import org.junit.Test;

public class AmqpBridgeApplicationPropertiesTest
extends AmqpClientTestSupport {
    private ActiveMQServer server0;
    private ActiveMQServer server1;
    private SimpleString customNotificationQueue;
    private SimpleString frameworkNotificationsQueue;
    private SimpleString bridgeNotificationsQueue;
    private SimpleString notificationsQueue;

    private String getServer0URL() {
        return "tcp://localhost:61616";
    }

    private String getServer1URL() {
        return "tcp://localhost:61617";
    }

    @Override
    public URI getBrokerAmqpConnectionURI() {
        try {
            return new URI(this.getServer0URL());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server0 = this.createServer(false, (Configuration)this.createBasicConfig());
        this.server1 = this.createServer(false, (Configuration)this.createBasicConfig());
        this.server0.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer0URL());
        this.server0.getConfiguration().addConnectorConfiguration("notification-broker", this.getServer1URL());
        this.server1.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer1URL());
        DivertConfiguration customNotificationsDivert = new DivertConfiguration().setName("custom-notifications-divert").setAddress("*.Provider.*.Agent.*.CustomNotification").setForwardingAddress("FrameworkNotifications").setExclusive(true).setTransformerConfiguration(new TransformerConfiguration(DivertApplicationPropertiesTransformer.class.getName()));
        DivertConfiguration frameworkNotificationsDivert = new DivertConfiguration().setName("framework-notifications-divert").setAddress("BridgeNotifications").setForwardingAddress("Notifications").setRoutingType(ComponentConfigurationRoutingType.MULTICAST).setExclusive(true);
        this.server0.getConfiguration().addDivertConfiguration(customNotificationsDivert);
        this.server1.getConfiguration().addDivertConfiguration(frameworkNotificationsDivert);
        this.customNotificationQueue = SimpleString.toSimpleString((String)"*.Provider.*.Agent.*.CustomNotification");
        this.frameworkNotificationsQueue = SimpleString.toSimpleString((String)"FrameworkNotifications");
        this.bridgeNotificationsQueue = SimpleString.toSimpleString((String)"BridgeNotifications");
        this.notificationsQueue = SimpleString.toSimpleString((String)"Notifications");
        this.server0.start();
        this.server1.start();
        this.server0.createQueue(new QueueConfiguration(this.customNotificationQueue).setRoutingType(RoutingType.ANYCAST));
        this.server0.createQueue(new QueueConfiguration(this.frameworkNotificationsQueue).setRoutingType(RoutingType.ANYCAST));
        this.server1.createQueue(new QueueConfiguration(this.bridgeNotificationsQueue).setRoutingType(RoutingType.ANYCAST));
        this.server1.createQueue(new QueueConfiguration(this.notificationsQueue));
        this.server0.deployBridge(new BridgeConfiguration().setName("notifications-bridge").setQueueName(this.frameworkNotificationsQueue.toString()).setForwardingAddress(this.bridgeNotificationsQueue.toString()).setConfirmationWindowSize(10).setStaticConnectors(Arrays.asList("notification-broker")).setTransformerConfiguration(new TransformerConfiguration(BridgeApplicationPropertiesTransformer.class.getName())));
    }

    @Test
    public void testApplicationPropertiesFromTransformerForwardBridge() throws Exception {
        HashMap<String, String> applicationProperties = new HashMap<String, String>();
        applicationProperties.put("trxId", "100");
        this.sendMessages("uswest.Provider.AMC.Agent.f261d0fa-51bd-44bd-abe0-ce22d2a387cd.CustomNotification", 1, RoutingType.ANYCAST, true);
        try (ServerLocator locator = ActiveMQClient.createServerLocator((String)this.getServer1URL());
             ClientSessionFactory sessionFactory = locator.createSessionFactory();
             ClientSession session = sessionFactory.createSession();
             ClientConsumer consumer = session.createConsumer(this.notificationsQueue);){
            session.start();
            ClientMessage message = consumer.receive(5000L);
            AmqpBridgeApplicationPropertiesTest.assertNotNull((Object)message);
            AmqpBridgeApplicationPropertiesTest.assertEquals((Object)"1", (Object)message.getStringProperty("A"));
            AmqpBridgeApplicationPropertiesTest.assertEquals((Object)"2", (Object)message.getStringProperty("B"));
            AmqpBridgeApplicationPropertiesTest.assertEquals((Object)"3", (Object)message.getStringProperty("C"));
            AmqpBridgeApplicationPropertiesTest.assertEquals((Object)"4", (Object)message.getStringProperty("D"));
        }
    }

    public static class BridgeApplicationPropertiesTransformer
    implements Transformer {
        public Message transform(Message message) {
            message.putStringProperty("C", "3");
            message.putStringProperty("D", "4");
            message.reencode();
            return message;
        }
    }

    public static class DivertApplicationPropertiesTransformer
    implements Transformer {
        public static final String TRX_ID = "trxId";

        public Message transform(Message message) {
            message.putStringProperty("A", "1");
            message.putStringProperty("B", "2");
            message.reencode();
            return message;
        }
    }
}

