/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.JMSException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpUnknownFilterType;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.junit.Test;

public class AmqpReceiverTest
extends AmqpClientTestSupport {
    @Test(timeout=60000L)
    public void testCreateQueueReceiver() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpReceiverTest.assertNotNull((Object)queue);
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCreateTopicReceiver() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getTopicName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpReceiverTest.assertNotNull((Object)queue);
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCreateQueueReceiverWithNoLocalSet() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Receiver receiver) {
                Source source;
                Map filters;
                if (receiver.getRemoteSource() == null) {
                    this.markAsInvalid("Link opened with null source.");
                }
                if (AmqpSupport.findFilter((Map)(filters = (source = (Source)receiver.getRemoteSource()).getFilter()), (Object[])AmqpSupport.NO_LOCAL_FILTER_IDS) != null) {
                    this.markAsInvalid("Broker did not return the NoLocal Filter on Attach");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        session.createReceiver(this.getQueueName(), null, true);
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCreateQueueReceiverWithJMSSelector() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Receiver receiver) {
                Source source;
                Map filters;
                if (receiver.getRemoteSource() == null) {
                    this.markAsInvalid("Link opened with null source.");
                }
                if (AmqpSupport.findFilter((Map)(filters = (source = (Source)receiver.getRemoteSource()).getFilter()), (Object[])AmqpSupport.JMS_SELECTOR_FILTER_IDS) == null) {
                    this.markAsInvalid("Broker did not return the JMS Filter on Attach");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        session.createReceiver(this.getQueueName(), "JMSPriority > 8");
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testInvalidFilter() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            session.createReceiver(this.getQueueName(), "null = 'f''", true);
            AmqpReceiverTest.fail((String)"should throw exception");
        }
        catch (Exception e) {
            AmqpReceiverTest.assertTrue((boolean)(e.getCause() instanceof JMSException));
        }
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSenderSettlementModeSettledIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.SETTLED);
    }

    @Test(timeout=60000L)
    public void testSenderSettlementModeUnsettledIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.UNSETTLED);
    }

    @Test(timeout=60000L)
    public void testSenderSettlementModeMixedIsHonored() throws Exception {
        this.doTestSenderSettlementModeIsHonored(SenderSettleMode.MIXED);
    }

    public void doTestSenderSettlementModeIsHonored(SenderSettleMode settleMode) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver("queue://" + this.getTestName(), settleMode, ReceiverSettleMode.FIRST);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpReceiverTest.assertNotNull((Object)queueView);
        AmqpReceiverTest.assertEquals((long)0L, (long)queueView.getMessageCount());
        AmqpReceiverTest.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        AmqpReceiverTest.assertEquals((Object)settleMode, (Object)((Receiver)receiver.getEndpoint()).getRemoteSenderSettleMode());
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReceiverSettlementModeSetToFirst() throws Exception {
        this.doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode.FIRST);
    }

    @Test(timeout=60000L)
    public void testReceiverSettlementModeSetToSecond() throws Exception {
        this.doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode.SECOND);
    }

    private void doTestReceiverSettlementModeForcedToFirst(ReceiverSettleMode modeToUse) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver("queue://" + this.getTestName(), SenderSettleMode.MIXED, modeToUse);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpReceiverTest.assertNotNull((Object)queueView);
        AmqpReceiverTest.assertEquals((long)0L, (long)queueView.getMessageCount());
        AmqpReceiverTest.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        AmqpReceiverTest.assertEquals((Object)ReceiverSettleMode.FIRST, (Object)((Receiver)receiver.getEndpoint()).getRemoteReceiverSettleMode());
        receiver.close();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testClientIdIsSetInSubscriptionList() throws Exception {
        this.server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"mytopic"), RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        connection.setContainerId("testClient");
        connection.connect();
        try {
            AmqpSession session = connection.createSession();
            Source source = new Source();
            source.setDurable(TerminusDurability.UNSETTLED_STATE);
            source.setCapabilities(new Symbol[]{Symbol.getSymbol((String)"topic")});
            source.setAddress("mytopic");
            session.createReceiver(source, "testSub");
            SimpleString fo = new SimpleString("testClient.testSub:mytopic");
            AmqpReceiverTest.assertNotNull((Object)this.server.locateQueue(fo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testLinkDetachSentWhenQueueDeleted() throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            this.server.destroyQueue(new SimpleString(this.getQueueName()), null, false, true);
            Wait.assertTrue((String)"Receiver should have closed", () -> ((AmqpReceiver)receiver).isClosed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testLinkDetatchErrorIsCorrectWhenQueueDoesNotExists() throws Exception {
        AddressSettings value = new AddressSettings();
        value.setAutoCreateQueues(Boolean.valueOf(false));
        value.setAutoCreateAddresses(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch("AnAddressThatDoesNotExist", (Object)value);
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            Exception expectedException = null;
            try {
                session.createSender("AnAddressThatDoesNotExist");
                AmqpReceiverTest.fail((String)"Creating a sender here on an address that doesn't exist should fail");
            }
            catch (Exception e) {
                expectedException = e;
            }
            AmqpReceiverTest.assertNotNull((Object)expectedException);
            AmqpReceiverTest.assertTrue((boolean)expectedException.getMessage().contains("amqp:not-found"));
            AmqpReceiverTest.assertTrue((boolean)expectedException.getMessage().contains("target address does not exist"));
        }
    }

    @Test(timeout=60000L)
    public void testUnsupportedFiltersAreNotListedAsSupported() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Receiver receiver) {
                Source source;
                Map filters;
                if (receiver.getRemoteSource() == null) {
                    this.markAsInvalid("Link opened with null source.");
                }
                if (AmqpSupport.findFilter((Map)(filters = (source = (Source)receiver.getRemoteSource()).getFilter()), (Object[])AmqpUnknownFilterType.UNKNOWN_FILTER_IDS) != null) {
                    this.markAsInvalid("Broker should not return unsupported filter on attach.");
                }
            }
        });
        HashMap<Symbol, AmqpUnknownFilterType> filters = new HashMap<Symbol, AmqpUnknownFilterType>();
        filters.put(AmqpUnknownFilterType.UNKNOWN_FILTER_NAME, AmqpUnknownFilterType.UNKNOWN_FILTER);
        Source source = new Source();
        source.setAddress(this.getQueueName());
        source.setFilter(filters);
        source.setDurable(TerminusDurability.NONE);
        source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiverTest.assertEquals((long)0L, (long)this.server.getTotalConsumerCount());
        session.createReceiver(source);
        AmqpReceiverTest.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testReceiverCloseSendsRemoteClose() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpReceiverTest.assertNotNull((Object)client);
        final AtomicBoolean closed = new AtomicBoolean();
        client.setValidator(new AmqpValidator(){

            public void inspectClosedResource(Session session) {
            }

            public void inspectDetachedResource(Receiver receiver) {
                this.markAsInvalid("Broker should not detach receiver linked to closed session.");
            }

            public void inspectClosedResource(Receiver receiver) {
                closed.set(true);
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpReceiverTest.assertNotNull((Object)connection);
        AmqpSession session = connection.createSession();
        AmqpReceiverTest.assertNotNull((Object)session);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        AmqpReceiverTest.assertNotNull((Object)receiver);
        receiver.close();
        AmqpReceiverTest.assertTrue((String)"Did not process remote close as expected", (boolean)closed.get());
        connection.getStateInspector().assertValid();
        connection.close();
    }
}

