/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.junit.Test;

public class AmqpSecurityTest
extends AmqpClientTestSupport {
    @Override
    protected boolean isSecurityEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSaslAuthWithInvalidCredentials() throws Exception {
        AmqpClient client = this.createAmqpClient(this.fullUser, this.guestUser);
        try (AmqpConnection connection = null;){
            connection = client.connect();
            AmqpSecurityTest.fail((String)"Should not authenticate when invalid credentials provided");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSaslAuthWithAuthzid() throws Exception {
        AmqpConnection connection = null;
        AmqpClient client = this.createAmqpClient(this.guestUser, this.guestPass);
        client.setAuthzid(this.guestUser);
        try {
            connection = client.connect();
        }
        catch (Exception ex) {
            AmqpSecurityTest.fail((String)"Should authenticate even with authzid set");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSaslAuthWithoutAuthzid() throws Exception {
        AmqpClient client = this.createAmqpClient(this.guestUser, this.guestPass);
        try (AmqpConnection connection = null;){
            connection = client.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendAndRejected() throws Exception {
        AmqpClient client = this.createAmqpClient(this.guestUser, this.guestPass);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Sender sender) {
                ErrorCondition condition = sender.getRemoteCondition();
                if (condition != null && condition.getCondition() != null) {
                    if (!condition.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                        this.markAsInvalid("Should have been tagged with unauthorized access error");
                    }
                } else {
                    this.markAsInvalid("Sender should have been opened with an error");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            try {
                session.createSender(this.getQueueName());
                AmqpSecurityTest.fail((String)"Should not be able to consume here.");
            }
            catch (Exception ex) {
                this.instanceLog.debug((Object)"Caught expected exception");
            }
            connection.getStateInspector().assertValid();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSendMessageFailsOnAnonymousRelayWhenNotAuthorizedToSendToAddress() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        AmqpClient client = this.createAmqpClient(this.guestUser, this.guestPass);
        client.setValidator(new AmqpValidator(){

            public void inspectDeliveryUpdate(Sender sender, Delivery delivery) {
                DeliveryState state = delivery.getRemoteState();
                if (!delivery.remotelySettled()) {
                    this.markAsInvalid("delivery is not remotely settled");
                }
                if (state instanceof Rejected) {
                    Rejected rejected = (Rejected)state;
                    if (rejected.getError() == null || rejected.getError().getCondition() == null) {
                        this.markAsInvalid("Delivery should have been Rejected with an error condition");
                    } else {
                        ErrorCondition error = rejected.getError();
                        if (!error.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                            this.markAsInvalid("Should have been tagged with unauthorized access error");
                        }
                    }
                } else {
                    this.markAsInvalid("Delivery should have been Rejected");
                }
                latch.countDown();
            }
        });
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createAnonymousSender();
            AmqpMessage message = new AmqpMessage();
            message.setAddress(this.getQueueName());
            message.setMessageId("msg1");
            message.setText("Test-Message");
            try {
                sender.send(message);
                AmqpSecurityTest.fail((String)"Should not be able to send, message should be rejected");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                sender.close();
            }
            AmqpSecurityTest.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
            connection.getStateInspector().assertValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReceiverNotAuthorized() throws Exception {
        AmqpClient client = this.createAmqpClient(this.noprivUser, this.noprivPass);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Receiver receiver) {
                ErrorCondition condition = receiver.getRemoteCondition();
                if (condition != null && condition.getCondition() != null) {
                    if (!condition.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                        this.markAsInvalid("Should have been tagged with unauthorized access error");
                    }
                } else {
                    this.markAsInvalid("Receiver should have been opened with an error");
                }
            }
        });
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            try {
                session.createReceiver(this.getQueueName());
                AmqpSecurityTest.fail((String)"Should not be able to consume here.");
            }
            catch (Exception ex) {
                this.instanceLog.debug((Object)"Caught expected exception");
            }
            connection.getStateInspector().assertValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testConsumerNotAuthorizedToCreateQueues() throws Exception {
        AmqpClient client = this.createAmqpClient(this.noprivUser, this.noprivPass);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Sender sender) {
                ErrorCondition condition = sender.getRemoteCondition();
                if (condition != null && condition.getCondition() != null) {
                    if (!condition.getCondition().equals(AmqpError.UNAUTHORIZED_ACCESS)) {
                        this.markAsInvalid("Should have been tagged with unauthorized access error");
                    }
                } else {
                    this.markAsInvalid("Sender should have been opened with an error");
                }
            }
        });
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            try {
                session.createReceiver(this.getQueueName(this.getPrecreatedQueueSize() + 1));
                AmqpSecurityTest.fail((String)"Should not be able to consume here.");
            }
            catch (Exception ex) {
                this.instanceLog.debug((Object)"Caught expected exception");
            }
            connection.getStateInspector().assertValid();
        }
    }
}

