/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class DLQAfterExpiredMessageTest
extends AmqpClientTestSupport {
    private static final Logger log = Logger.getLogger(DLQAfterExpiredMessageTest.class);

    protected String getExpiryQueue() {
        return "ActiveMQ.Expiry";
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)this.getQueueName()), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.getQueueName()).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)this.getDeadLetterAddress()), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.getDeadLetterAddress()).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)this.getExpiryQueue()), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(this.getExpiryQueue()).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)this.getTopicName()), RoutingType.MULTICAST));
        server.createQueue(new QueueConfiguration(this.getTopicName()));
        for (int i = 0; i < this.getPrecreatedQueueSize(); ++i) {
            server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)this.getQueueName(i)), RoutingType.ANYCAST));
            server.createQueue(new QueueConfiguration(this.getQueueName(i)).setRoutingType(RoutingType.ANYCAST));
        }
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.toSimpleString((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.toSimpleString((String)this.getExpiryQueue()));
        addressSettings.setMaxDeliveryAttempts(1);
        server.getConfiguration().getAddressesSettings().put("#", addressSettings);
        server.getConfiguration().getAddressesSettings().put(this.getExpiryQueue(), addressSettings);
    }

    @Test
    public void testDoubleTransfer() throws Throwable {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            DLQAfterExpiredMessageTest.assertNotNull((Object)queueView);
            AmqpMessage message = new AmqpMessage();
            message.setTimeToLive(1L);
            message.setText("Test-Message");
            message.setDurable(true);
            message.setApplicationProperty("key1", (Object)"Value1");
            sender.send(message);
            sender.close();
            Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
            Wait.assertEquals((int)0, () -> ((Queue)queueView).getConsumerCount());
            Queue expiryView = this.getProxyToQueue(this.getExpiryQueue());
            DLQAfterExpiredMessageTest.assertNotNull((Object)expiryView);
            Wait.assertEquals((long)1L, () -> ((Queue)expiryView).getMessageCount());
            HashMap annotations = new HashMap();
            AmqpReceiver receiverDLQ = session.createReceiver(this.getExpiryQueue(), "\"m." + AMQPMessageSupport.HDR_ORIGINAL_ADDRESS_ANNOTATION + "\"='" + this.getQueueName() + "'");
            receiverDLQ.flow(1);
            AmqpMessage received = receiverDLQ.receive(5L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)received);
            Map avAnnotations = received.getWrappedMessage().getMessageAnnotations().getValue();
            avAnnotations.forEach((key, value) -> annotations.put(key.toString(), value));
            received.reject();
            receiverDLQ.close();
            receiverDLQ = session.createReceiver(this.getDeadLetterAddress(), "\"m." + AMQPMessageSupport.HDR_ORIGINAL_ADDRESS_ANNOTATION + "\"='" + this.getExpiryQueue() + "'");
            receiverDLQ.flow(1);
            received = receiverDLQ.receive(5L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)received);
            received.accept();
            DLQAfterExpiredMessageTest.assertEquals((long)0L, (long)received.getTimeToLive());
            DLQAfterExpiredMessageTest.assertNotNull((Object)received);
            DLQAfterExpiredMessageTest.assertEquals((Object)"Value1", (Object)received.getApplicationProperty("key1"));
        }
    }
}

