/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketConnectionTest
extends JMSClientTestSupport {
    @Override
    public boolean isUseWebSockets() {
        return true;
    }

    @Test
    public void testSingleKeepAliveIsReleasedWhenWebSocketUpgradeHappens() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        this.produceAndConsumeInNewConnection(factory);
        this.assertKeepAliveCounterIsZero();
    }

    @Test
    public void testMultipleKeepAliveAreReleasedWhenWebSocketUpgradeHappens() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory(this.getBrokerQpidJMSConnectionURI());
        this.produceAndConsumeInNewConnection(factory);
        this.produceAndConsumeInNewConnection(factory);
        this.produceAndConsumeInNewConnection(factory);
        this.produceAndConsumeInNewConnection(factory);
        this.produceAndConsumeInNewConnection(factory);
        this.assertKeepAliveCounterIsZero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceAndConsumeInNewConnection(JmsConnectionFactory factory) throws JMSException {
        try (JmsConnection connection = (JmsConnection)factory.createConnection();){
            Session session = connection.createSession();
            Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send(session.createMessage());
            producer.close();
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(1000L);
            WebSocketConnectionTest.assertNotNull((Object)message);
        }
    }

    private void assertKeepAliveCounterIsZero() {
        NettyAcceptor nettyAcceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("netty-acceptor");
        int httpAcceptorHandlerCount = nettyAcceptor.getProtocolHandler().getHttpKeepAliveRunnable().getHandlers().size();
        Assert.assertEquals((long)0L, (long)httpAcceptorHandlerCount);
    }
}

