/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.paging;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpTestSupport;
import org.apache.activemq.artemis.tests.unit.core.paging.impl.PageTest;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AmqpPageTest
extends PageTest {
    private static MessageImpl createProtonMessage(String address, byte[] content) {
        AmqpMessage message = new AmqpMessage();
        message.setBytes(content);
        message.setAddress(address);
        message.setDurable(true);
        MessageImpl protonMessage = (MessageImpl)message.getWrappedMessage();
        return protonMessage;
    }

    private static AMQPStandardMessage createStandardMessage(SimpleString address, long msgId, byte[] content) {
        MessageImpl protonMessage = AmqpPageTest.createProtonMessage(address.toString(), content);
        AMQPStandardMessage amqpMessage = AmqpTestSupport.encodeAndDecodeMessage(0, protonMessage, content.length + 1000);
        amqpMessage.setMessageID(msgId);
        return amqpMessage;
    }

    private static AMQPLargeMessage createLargeMessage(StorageManager storageManager, SimpleString address, long msgId, byte[] content) throws Exception {
        AMQPLargeMessage amqpMessage = new AMQPLargeMessage(msgId, 0L, null, null, storageManager);
        amqpMessage.setAddress(address);
        amqpMessage.setFileDurable(true);
        amqpMessage.addBytes(content);
        amqpMessage.reloadExpiration(0L);
        return amqpMessage;
    }

    @Override
    protected void writeMessage(StorageManager storageManager, boolean isLargeMessage, long msgID, SimpleString address, byte[] content, Page page) throws Exception {
        if (!isLargeMessage) {
            AMQPStandardMessage message = AmqpPageTest.createStandardMessage(address, msgID, content);
            page.write((PagedMessage)new PagedMessageImpl((Message)message, new long[0]));
        } else {
            AMQPLargeMessage message = AmqpPageTest.createLargeMessage(storageManager, address, msgID, content);
            page.write((PagedMessage)new PagedMessageImpl((Message)message, new long[0]));
            message.releaseResources(false, false);
        }
    }
}

