/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class BlockingSendTest
extends ActiveMQTestBase {
    @Test
    public void testSinglePersistentBlockingNonSync() throws Exception {
        ActiveMQServer server = this.createServer(true);
        ClientSession session = null;
        ClientSessionFactory factory = null;
        ServerLocator locator = null;
        server.getConfiguration().setJournalSyncNonTransactional(false);
        server.getConfiguration().setJournalBufferTimeout_AIO(15000);
        server.start();
        this.instanceLog.debug((Object)("sync = " + server.getConfiguration().isJournalSyncNonTransactional()));
        locator = this.createInVMNonHALocator().setBlockOnDurableSend(true);
        factory = this.createSessionFactory(locator);
        session = factory.createSession();
        session.createQueue(new QueueConfiguration("queue").setAddress("address").setRoutingType(RoutingType.ANYCAST));
        ClientProducer prod = session.createProducer("address");
        ClientMessage message = session.createMessage(true);
        prod.send((Message)message);
        ClientConsumer consumer = session.createConsumer("queue");
        session.start();
        ClientMessage msg = consumer.receive(5000L);
        Assert.assertNotNull((Object)msg);
        msg.acknowledge();
    }
}

