/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageDurabilityTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession session;
    private ClientSessionFactory sf;
    private ServerLocator locator;

    @Test
    public void testNonDurableMessageOnNonDurableQueue() throws Exception {
        boolean durable = true;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(!durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(!durable));
        this.restart();
        this.session.start();
        try {
            this.session.createConsumer(queue);
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
        }
        catch (ActiveMQException e) {
            MessageDurabilityTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testNonDurableMessageOnDurableQueue() throws Exception {
        boolean durable = true;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(!durable));
        this.restart();
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        Assert.assertNull((Object)consumer.receiveImmediate());
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testDurableMessageOnDurableQueue() throws Exception {
        boolean durable = true;
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(durable));
        this.restart();
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        Assert.assertNotNull((Object)consumer.receive(500L));
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testDurableMessageOnNonDurableQueue() throws Exception {
        boolean durable = true;
        SimpleString address = RandomUtil.randomSimpleString();
        final SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(!durable)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(durable));
        this.restart();
        this.session.start();
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                MessageDurabilityTest.this.session.createConsumer(queue);
            }
        });
    }

    @Test
    public void testDurableMessageOnTemporaryQueue() throws Exception {
        boolean durable = true;
        SimpleString address = RandomUtil.randomSimpleString();
        final SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(durable));
        this.restart();
        this.session.start();
        ActiveMQTestBase.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                MessageDurabilityTest.this.session.createConsumer(queue);
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }

    private void restart() throws Exception {
        this.session.close();
        this.server.stop();
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true);
    }
}

