/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReceiveTest
extends ActiveMQTestBase {
    SimpleString addressA;
    SimpleString addressB;
    SimpleString queueA;
    SimpleString queueB;
    private ServerLocator locator;
    private ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.addressA = RandomUtil.randomSimpleString();
        this.queueA = RandomUtil.randomSimpleString();
        this.addressB = RandomUtil.randomSimpleString();
        this.queueB = RandomUtil.randomSimpleString();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void testBasicReceive() throws Exception {
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientConsumer cc = session.createConsumer(this.queueA);
        session.start();
        cp.send((Message)sendSession.createMessage(false));
        Assert.assertNotNull((Object)cc.receive());
        session.close();
        sendSession.close();
    }

    @Test
    public void testReceiveTimesoutCorrectly() throws Exception {
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientConsumer cc = session.createConsumer(this.queueA);
        session.start();
        long time = System.currentTimeMillis();
        cc.receive(1000L);
        Assert.assertTrue((System.currentTimeMillis() - time >= 1000L ? (byte)1 : 0) != 0);
        session.close();
    }

    @Test
    public void testReceiveOnClosedException() throws Exception {
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientConsumer cc = session.createConsumer(this.queueA);
        session.start();
        session.close();
        try {
            cc.receive();
            Assert.fail((String)"should throw exception");
        }
        catch (ActiveMQObjectClosedException activeMQObjectClosedException) {
        }
        catch (ActiveMQException e) {
            Assert.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Test
    public void testReceiveThrowsExceptionWhenHandlerSet() throws Exception {
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientConsumer cc = session.createConsumer(this.queueA);
        session.start();
        cc.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
            }
        });
        try {
            cc.receive();
            Assert.fail((String)"should throw exception");
        }
        catch (ActiveMQIllegalStateException activeMQIllegalStateException) {
        }
        catch (ActiveMQException e) {
            Assert.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Test
    public void testReceiveImmediate() throws Exception {
        this.locator.setConsumerWindowSize(0);
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientProducer cp = sendSession.createProducer(this.addressA);
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientConsumer cc = session.createConsumer(this.queueA);
        ClientConsumer cc2 = session.createConsumer(this.queueA);
        session.start();
        cp.send((Message)sendSession.createMessage(false));
        cp.send((Message)sendSession.createMessage(false));
        cp.send((Message)sendSession.createMessage(false));
        sendSession.commit();
        Queue queue = this.server.locateQueue(this.queueA);
        Wait.waitFor(() -> queue.getMessageCount() == 3L, (long)500L, (long)100L);
        Assert.assertNotNull((Object)cc2.receiveImmediate());
        Assert.assertNotNull((Object)cc.receiveImmediate());
        if (cc.receiveImmediate() == null) {
            Assert.assertNotNull((Object)cc2.receiveImmediate());
        }
        session.close();
        sendSession.close();
    }

    @Test
    public void testMultiConsumersOnSession() throws Exception {
        ClientSessionFactory cf = this.createSessionFactory(this.locator.setCallTimeout(10000000L));
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientProducer cp1 = sendSession.createProducer(this.addressA);
        ClientProducer cp2 = sendSession.createProducer(this.addressB);
        ClientSession session = cf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(this.queueB).setAddress(this.addressB).setDurable(Boolean.valueOf(false)));
        ClientConsumer cc1 = session.createConsumer(this.queueA);
        ClientConsumer cc2 = session.createConsumer(this.queueB);
        session.start();
        cp1.send((Message)sendSession.createMessage(false));
        cp2.send((Message)sendSession.createMessage(false));
        Assert.assertNotNull((Object)cc1.receive().acknowledge());
        Assert.assertNotNull((Object)cc2.receive().acknowledge());
        session.commit();
        Queue queue1 = this.server.locateQueue(this.queueA);
        Queue queue2 = this.server.locateQueue(this.queueB);
        Wait.assertTrue(() -> queue1.getMessageCount() == 0L, (long)500L, (long)100L);
        Wait.assertTrue(() -> queue1.getMessagesAcknowledged() == 1L, (long)500L, (long)100L);
        Wait.assertTrue(() -> queue2.getMessageCount() == 0L, (long)500L, (long)100L);
        Wait.assertTrue(() -> queue2.getMessagesAcknowledged() == 1L, (long)500L, (long)100L);
        session.close();
        sendSession.close();
    }
}

