/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.uri.ServerLocatorParser;
import org.junit.Before;
import org.junit.Test;

public class ServerLocatorConnectTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultConfig(this.isNetty());
        this.server = this.createServer(false, configuration);
        this.server.start();
    }

    @Test
    public void testURL() throws Exception {
        ServerLocatorParser parser = new ServerLocatorParser();
        URI uri = new URI("tcp://localhost:61616?&blockOnNonDurableSend=true&retryIntervalMultiplier=1.0&maxRetryInterval=2000&producerMaxRate=-1&blockOnDurableSend=true&connectionTTL=60000&compressLargeMessage=false&reconnectAttempts=0&cacheLargeMessagesClient=false&scheduledThreadPoolMaxSize=5&useGlobalPools=true&callFailoverTimeout=-1&initialConnectAttempts=1&clientFailureCheckPeriod=30000&blockOnAcknowledge=true&consumerWindowSize=1048576&minLargeMessageSize=102400&autoGroup=false&threadPoolMaxSize=-1&confirmationWindowSize=-1&transactionBatchSize=1048576&callTimeout=30000&preAcknowledge=false&connectionLoadBalancingPolicyClassName=org.apache.activemq.artemis.api.core.client.loadbalance.RoundRobinConnectionLoadBalancingPolicy&dupsOKBatchSize=1048576&initialMessagePacketSize=1500&consumerMaxRate=-1&retryInterval=2000&producerWindowSize=65536&port=61616&host=localhost#");
        for (int i = 0; i < 10; ++i) {
            ServerLocator locator = (ServerLocator)parser.newObject(uri, null);
            ClientSessionFactory csf = this.createSessionFactory(locator);
            csf.close();
            locator.close();
        }
    }

    @Test
    public void testSingleConnectorSingleServer() throws Exception {
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)0, (boolean)this.isNetty()))});
        ClientSessionFactory csf = this.createSessionFactory(locator);
        csf.close();
        locator.close();
    }

    @Test
    public void testSingleConnectorSingleServerConnect() throws Exception {
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)0, (boolean)this.isNetty()))});
        ClientSessionFactoryInternal csf = locator.connect();
        ServerLocatorConnectTest.assertNotNull((Object)csf);
        ServerLocatorConnectTest.assertEquals((long)csf.numConnections(), (long)1L);
        locator.close();
    }

    @Test
    public void testMultipleConnectorSingleServerConnect() throws Exception {
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)0, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)1, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)2, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)3, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)4, (boolean)this.isNetty()))});
        ClientSessionFactoryInternal csf = locator.connect();
        ServerLocatorConnectTest.assertNotNull((Object)csf);
        ServerLocatorConnectTest.assertEquals((long)csf.numConnections(), (long)1L);
        locator.close();
    }

    @Test
    public void testMultipleConnectorSingleServerConnectReconnect() throws Exception {
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)0, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)1, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)2, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)3, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)4, (boolean)this.isNetty()))});
        locator.setReconnectAttempts(15);
        ClientSessionFactoryInternal csf = locator.connect();
        ServerLocatorConnectTest.assertNotNull((Object)csf);
        ServerLocatorConnectTest.assertEquals((long)csf.numConnections(), (long)1L);
        locator.close();
    }

    @Test
    public void testMultipleConnectorSingleServerNoConnect() throws Exception {
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)1, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)2, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)3, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)4, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)5, (boolean)this.isNetty()))});
        ClientSessionFactoryInternal csf = null;
        try {
            csf = locator.connect();
        }
        catch (ActiveMQNotConnectedException activeMQNotConnectedException) {
        }
        catch (Exception e) {
            ServerLocatorConnectTest.assertTrue((boolean)(e instanceof ActiveMQException));
            ServerLocatorConnectTest.fail((String)("Invalid Exception type:" + ((ActiveMQException)((Object)e)).getType()));
        }
        ServerLocatorConnectTest.assertNull((Object)csf);
        locator.close();
    }

    @Test
    public void testMultipleConnectorSingleServerNoConnectAttemptReconnect() throws Exception {
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)1, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)2, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)3, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)4, (boolean)this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)ServerLocatorConnectTest.generateParams((int)5, (boolean)this.isNetty()))});
        locator.setReconnectAttempts(15);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Connector target = new Connector(locator, countDownLatch);
        Thread t = new Thread(target);
        t.start();
        Thread.sleep(500L);
        locator.close();
        ServerLocatorConnectTest.assertTrue((boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
        ServerLocatorConnectTest.assertNull((Object)target.csf);
    }

    public boolean isNetty() {
        return true;
    }

    static class Connector
    implements Runnable {
        private final ServerLocatorInternal locator;
        ClientSessionFactory csf = null;
        CountDownLatch latch;
        Exception e;

        Connector(ServerLocatorInternal locator, CountDownLatch latch) {
            this.locator = locator;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.csf = this.locator.connect();
            }
            catch (Exception e) {
                this.e = e;
            }
            this.latch.countDown();
        }
    }
}

