/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AutoDeleteDistributedTest
extends ClusterTestBase {
    private static final Logger log = Logger.getLogger(AutoDeleteDistributedTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    protected ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl configuration = super.createBasicConfig(serverID);
        configuration.setJournalBufferTimeout_AIO(ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutAio()).setJournalBufferTimeout_NIO(ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutNio());
        return configuration;
    }

    private void start() throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.servers[0].start();
        this.servers[1].start();
        this.servers[2].start();
    }

    protected boolean isNetty() {
        return true;
    }

    @Override
    protected void setSessionFactoryCreateLocator(int node, boolean ha, TransportConfiguration serverTotc) {
        super.setSessionFactoryCreateLocator(node, ha, serverTotc);
        this.locators[node].setConsumerWindowSize(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDelete() throws Exception {
        AssertionLoggerHandler.startCapture();
        try {
            final AtomicBoolean error = new AtomicBoolean(false);
            int messageCount = 30;
            JMSContext client1JmsContext = this.createContext(0);
            JMSContext client2JmsContext = this.createContext(1);
            JMSConsumer client2JmsConsumer = client2JmsContext.createConsumer((Destination)client2JmsContext.createQueue("queues.myQueue"));
            final CountDownLatch onMessageReceived = new CountDownLatch(messageCount);
            client2JmsConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message m) {
                    log.debug((Object)("Message received. " + m));
                    onMessageReceived.countDown();
                }
            });
            final CountDownLatch onMessageSent = new CountDownLatch(1);
            JMSProducer jmsProducer = client1JmsContext.createProducer();
            jmsProducer.setAsync(new CompletionListener(){

                public void onCompletion(Message m) {
                    log.debug((Object)("Message sent. " + m));
                    onMessageSent.countDown();
                }

                public void onException(Message m, Exception ex) {
                    ex.printStackTrace();
                    error.set(true);
                }
            });
            for (int i = 0; i < messageCount; ++i) {
                BytesMessage jmsMsg = client1JmsContext.createBytesMessage();
                jmsMsg.setJMSType("MyType");
                jmsProducer.send((Destination)client1JmsContext.createQueue("queues.myQueue"), (Message)jmsMsg);
            }
            log.debug((Object)"Waiting for message to be sent...");
            onMessageSent.await(5L, TimeUnit.SECONDS);
            log.debug((Object)"Waiting for message to be received...");
            Assert.assertTrue((boolean)onMessageReceived.await(5L, TimeUnit.SECONDS));
            client2JmsConsumer.close();
            Assert.assertFalse((boolean)error.get());
            Thread.sleep(100L);
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"java.lang.IllegalStateException"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"Cannot find binding"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    private JMSContext createContext(int server) throws NamingException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:" + (61617 + server));
        return cf.createContext();
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 2, 0, 1);
    }

    protected void setRedistributionDelay(long delay) {
        AddressSettings as = new AddressSettings().setRedistributionDelay(delay);
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(2).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.servers[0].getConfiguration().addAddressesSetting("*", new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)).setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteQueues(Boolean.valueOf(true)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)));
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1, 2);
        this.clearServer(0, 1, 2);
    }
}

