/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.junit.Assert;

public class SameProcessActiveMQServer
implements TestableServer {
    private final ActiveMQServer server;

    public SameProcessActiveMQServer(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean isActive() {
        return this.server.isActive();
    }

    @Override
    public void setIdentity(String identity) {
        this.server.setIdentity(identity);
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)interceptor);
    }

    @Override
    public void removeInterceptor(Interceptor interceptor) {
        this.server.getRemotingService().removeIncomingInterceptor((BaseInterceptor)interceptor);
    }

    public void start() throws Exception {
        this.server.start();
    }

    @Override
    public void stop() throws Exception {
        this.server.stop();
    }

    @Override
    public CountDownLatch crash(ClientSession ... sessions) throws Exception {
        return this.crash(true, sessions);
    }

    @Override
    public CountDownLatch crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        return this.crash(true, waitFailure, sessions);
    }

    @Override
    public CountDownLatch crash(boolean failover, boolean waitFailure, ClientSession ... sessions) throws Exception {
        CountDownLatch latch = new CountDownLatch(sessions.length);
        CountDownSessionFailureListener[] listeners = new CountDownSessionFailureListener[sessions.length];
        long callTimeout = 0L;
        long failoverCallTimeout = 0L;
        for (int i = 0; i < sessions.length; ++i) {
            long timeout = sessions[i].getSessionFactory().getServerLocator().getCallTimeout();
            long failoverTimeout = sessions[i].getSessionFactory().getServerLocator().getCallFailoverTimeout();
            if (callTimeout < timeout) {
                callTimeout = timeout;
            }
            if (failoverCallTimeout < failoverTimeout) {
                failoverCallTimeout = failoverTimeout;
            }
            listeners[i] = new CountDownSessionFailureListener(latch, sessions[i]);
            sessions[i].addFailureListener((SessionFailureListener)listeners[i]);
        }
        ClusterManager clusterManager = this.server.getClusterManager();
        clusterManager.flushExecutor();
        clusterManager.clear();
        Assert.assertTrue((String)"server should be running!", (boolean)this.server.isStarted());
        this.server.fail(failover);
        if (waitFailure) {
            boolean ok = latch.await(callTimeout * 2L + failoverCallTimeout * 2L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)("Failed to stop the server! Latch count is " + latch.getCount() + " out of " + sessions.length), (boolean)ok);
        }
        return latch;
    }

    @Override
    public ActiveMQServer getServer() {
        return this.server;
    }
}

