/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class LVQTest
extends JMSTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    protected ConnectionFactory getCF() throws Exception {
        return this.cf;
    }

    @Test
    public void testLVQandNonDestructive() throws Exception {
        ActiveMQConnectionFactory fact = (ActiveMQConnectionFactory)this.getCF();
        fact.setConsumerWindowSize(0);
        try (Connection connection = fact.createConnection();
             Session session = connection.createSession(false, 2);){
            jakarta.jms.Queue queue = session.createQueue("random?last-value=true&non-destructive=true");
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage message = session.createTextMessage();
            message.setText("Message 1");
            message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), "A");
            producer.send((Message)message);
            TextMessage tm = (TextMessage)consumer.receive(2000L);
            LVQTest.assertNotNull((Object)tm);
            tm.acknowledge();
            Thread.sleep(1000L);
            LVQTest.assertEquals((Object)"Message 1", (Object)tm.getText());
            message = session.createTextMessage();
            message.setText("Message 2");
            message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), "A");
            producer.send((Message)message);
            tm = (TextMessage)consumer.receive(2000L);
            LVQTest.assertNotNull((Object)tm);
            LVQTest.assertEquals((Object)"Message 2", (Object)tm.getText());
            Queue serverQueue = this.server.locateQueue("random");
            Wait.assertEquals((long)1L, () -> ((Queue)serverQueue).getMessageCount());
        }
        Queue serverQueue = this.server.locateQueue("random");
        Wait.assertEquals((long)1L, () -> ((Queue)serverQueue).getMessageCount());
        serverQueue.deleteMatchingReferences(null);
        LVQTest.assertEquals((long)0L, (long)serverQueue.getMessageCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastValueQueueUsingAddressQueueParameters() throws Exception {
        ActiveMQConnectionFactory fact = (ActiveMQConnectionFactory)this.getCF();
        fact.setConsumerWindowSize(0);
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            jakarta.jms.Queue queue = session.createQueue("random?last-value=true");
            LVQTest.assertEquals((Object)"random", (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            LVQTest.assertTrue((boolean)a.getQueueAttributes().getLastValue());
            LVQTest.assertTrue((boolean)a.getQueueConfiguration().isLastValue());
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            connection.start();
            for (int j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), "key");
                producer.send((Message)message);
            }
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            LVQTest.assertNotNull((Object)tm);
            LVQTest.assertEquals((Object)"Message99", (Object)tm.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastValueQueueTopicConsumerUsingAddressQueueParameters() throws Exception {
        ActiveMQConnectionFactory fact = (ActiveMQConnectionFactory)this.getCF();
        fact.setConsumerWindowSize(0);
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            Topic topic = session.createTopic("topic?last-value=true");
            LVQTest.assertEquals((Object)"topic", (Object)topic.getTopicName());
            ActiveMQDestination a = (ActiveMQDestination)topic;
            LVQTest.assertTrue((boolean)a.getQueueAttributes().getLastValue());
            LVQTest.assertTrue((boolean)a.getQueueConfiguration().isLastValue());
            MessageProducer producer = session.createProducer((Destination)topic);
            MessageConsumer consumer1 = session.createConsumer((Destination)topic);
            MessageConsumer consumer2 = session.createConsumer((Destination)topic);
            connection.start();
            for (int j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), "key");
                producer.send((Message)message);
            }
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            LVQTest.assertNotNull((Object)tm);
            LVQTest.assertEquals((Object)"Message99", (Object)tm.getText());
            TextMessage tm2 = (TextMessage)consumer2.receive(10000L);
            LVQTest.assertNotNull((Object)tm2);
            LVQTest.assertEquals((Object)"Message99", (Object)tm2.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastValueKeyUsingAddressQueueParameters() throws Exception {
        ActiveMQConnectionFactory fact = (ActiveMQConnectionFactory)this.getCF();
        fact.setConsumerWindowSize(0);
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            jakarta.jms.Queue queue = session.createQueue("random?last-value-key=reuters_code");
            LVQTest.assertEquals((Object)"random", (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            LVQTest.assertEquals((Object)"reuters_code", (Object)a.getQueueAttributes().getLastValueKey().toString());
            LVQTest.assertEquals((Object)"reuters_code", (Object)a.getQueueConfiguration().getLastValueKey().toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            connection.start();
            for (int j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                message.setStringProperty("reuters_code", "key");
                producer.send((Message)message);
            }
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            LVQTest.assertNotNull((Object)tm);
            LVQTest.assertEquals((Object)"Message99", (Object)tm.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastValueKeyTopicConsumerUsingAddressQueueParameters() throws Exception {
        ActiveMQConnectionFactory fact = (ActiveMQConnectionFactory)this.getCF();
        fact.setConsumerWindowSize(0);
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            Topic topic = session.createTopic("topic?last-value-key=reuters_code");
            LVQTest.assertEquals((Object)"topic", (Object)topic.getTopicName());
            ActiveMQDestination a = (ActiveMQDestination)topic;
            LVQTest.assertEquals((Object)"reuters_code", (Object)a.getQueueAttributes().getLastValueKey().toString());
            LVQTest.assertEquals((Object)"reuters_code", (Object)a.getQueueConfiguration().getLastValueKey().toString());
            MessageProducer producer = session.createProducer((Destination)topic);
            MessageConsumer consumer1 = session.createConsumer((Destination)topic);
            MessageConsumer consumer2 = session.createConsumer((Destination)topic);
            connection.start();
            for (int j = 0; j < 100; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                message.setStringProperty("reuters_code", "key");
                producer.send((Message)message);
            }
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            LVQTest.assertNotNull((Object)tm);
            LVQTest.assertEquals((Object)"Message99", (Object)tm.getText());
            TextMessage tm2 = (TextMessage)consumer2.receive(10000L);
            LVQTest.assertNotNull((Object)tm2);
            LVQTest.assertEquals((Object)"Message99", (Object)tm2.getText());
        }
    }
}

