/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.Before;
import org.junit.Test;

public class SelectorRedistributionClusterTest
extends JMSClusteredTestBase {
    private final String myQueue = "myQueue";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.jmsServer1.getActiveMQServer().setIdentity("Server 1");
        this.jmsServer2.getActiveMQServer().setIdentity("Server 2");
    }

    @Override
    protected boolean enablePersistence() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectorRoutingReDistributionOnNoConsumer() throws Exception {
        ((AddressSettings)this.server1.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        ((AddressSettings)this.server2.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        Connection conn1 = this.cf1.createConnection();
        Connection conn2 = this.cf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            Session session1 = conn1.createSession(false, 2);
            Session session2 = conn2.createSession(false, 2);
            Queue jmsQueue = session1.createQueue("myQueue");
            MessageProducer prod1 = session1.createProducer((Destination)jmsQueue);
            prod1.setDeliveryMode(2);
            TextMessage textMessage = session1.createTextMessage("m1");
            textMessage.setIntProperty("N", 10);
            MessageConsumer cons2 = session2.createConsumer((Destination)jmsQueue, "N = 10");
            MessageConsumer cons1 = session1.createConsumer((Destination)jmsQueue, "N = 0");
            this.waitForBindings(this.server1, "myQueue", false, 1, 1, 4000L);
            prod1.send((Message)textMessage);
            TextMessage received = (TextMessage)cons2.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            session2.close();
            session2 = conn2.createSession(false, 2);
            cons2 = session2.createConsumer((Destination)jmsQueue, "N = 10");
            received = (TextMessage)cons2.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            MessageConsumer cons11 = session1.createConsumer((Destination)jmsQueue, "N = 10");
            session2.close();
            received = (TextMessage)cons11.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            received.acknowledge();
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectorRoutingNoReDistributionNewMessageSkipsTillLocalClose() throws Exception {
        ((AddressSettings)this.server1.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        ((AddressSettings)this.server2.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        Connection conn1 = this.cf1.createConnection();
        Connection conn2 = this.cf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            Session session1 = conn1.createSession(false, 2);
            Session session11 = conn1.createSession(false, 2);
            Session session2 = conn2.createSession(false, 2);
            Queue jmsQueue = session1.createQueue("myQueue");
            MessageProducer prod1 = session1.createProducer((Destination)jmsQueue);
            prod1.setDeliveryMode(2);
            TextMessage textMessage = session1.createTextMessage("m1");
            textMessage.setIntProperty("N", 10);
            MessageConsumer cons2 = session2.createConsumer((Destination)jmsQueue, "N = 10");
            MessageConsumer cons1 = session1.createConsumer((Destination)jmsQueue, "N = 0");
            MessageConsumer cons11 = session11.createConsumer((Destination)jmsQueue, "N = 10");
            this.waitForBindings(this.server1, "myQueue", false, 1, 1, 4000L);
            prod1.send((Message)textMessage);
            TextMessage received = (TextMessage)cons11.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            session11.close();
            received = (TextMessage)cons2.receiveNoWait();
            SelectorRedistributionClusterTest.assertNull((Object)received);
            textMessage = session1.createTextMessage("m2");
            textMessage.setIntProperty("N", 10);
            prod1.send((Message)textMessage);
            received = (TextMessage)cons2.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m2", (Object)received.getText());
            received.acknowledge();
            session1.close();
            received = (TextMessage)cons2.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            received.acknowledge();
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectorRoutingReDistributionDoesNotBlockLocalConsumer() throws Exception {
        ((AddressSettings)this.server1.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        ((AddressSettings)this.server2.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        Connection conn1 = this.cf1.createConnection();
        Connection conn2 = this.cf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            Session session1 = conn1.createSession(false, 2);
            Session session11 = conn1.createSession(false, 2);
            Session session2 = conn2.createSession(false, 2);
            Queue jmsQueue = session1.createQueue("myQueue");
            MessageProducer prod1 = session1.createProducer((Destination)jmsQueue);
            prod1.setDeliveryMode(2);
            TextMessage textMessage = session1.createTextMessage("m1");
            textMessage.setIntProperty("N", 10);
            MessageConsumer cons1_0 = session1.createConsumer((Destination)jmsQueue, "N = 0");
            MessageConsumer cons1_1 = session1.createConsumer((Destination)jmsQueue, "N = 1");
            MessageConsumer cons1_10 = session11.createConsumer((Destination)jmsQueue, "N = 10");
            prod1.send((Message)textMessage);
            TextMessage received = (TextMessage)cons1_10.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            session11.close();
            MessageConsumer cons2_10 = session2.createConsumer((Destination)jmsQueue, "N = 10");
            received = (TextMessage)cons2_10.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            received.acknowledge();
            textMessage = session1.createTextMessage("m2");
            textMessage.setIntProperty("N", 0);
            prod1.send((Message)textMessage);
            textMessage = session1.createTextMessage("m3");
            textMessage.setIntProperty("N", 1);
            prod1.send((Message)textMessage);
            received = (TextMessage)cons1_0.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m2", (Object)received.getText());
            received.acknowledge();
            received = (TextMessage)cons1_1.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m3", (Object)received.getText());
            received.acknowledge();
            textMessage = session1.createTextMessage("m4");
            textMessage.setIntProperty("N", 10);
            prod1.send((Message)textMessage);
            received = (TextMessage)cons2_10.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m4", (Object)received.getText());
            received.acknowledge();
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectorRoutingReDistributionOnConsumerMove() throws Exception {
        ((AddressSettings)this.server1.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        ((AddressSettings)this.server2.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        Connection conn1 = this.cf1.createConnection();
        Connection conn2 = this.cf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            Session session1 = conn1.createSession(false, 2);
            Session session11 = conn1.createSession(false, 2);
            Session session2 = conn2.createSession(false, 2);
            Queue jmsQueue = session1.createQueue("myQueue");
            MessageProducer prod1 = session1.createProducer((Destination)jmsQueue);
            prod1.setDeliveryMode(2);
            TextMessage textMessage = session1.createTextMessage("m1");
            textMessage.setIntProperty("N", 10);
            MessageConsumer cons1 = session1.createConsumer((Destination)jmsQueue, "N = 0");
            MessageConsumer cons12 = session1.createConsumer((Destination)jmsQueue, "N = 1");
            MessageConsumer cons111 = session11.createConsumer((Destination)jmsQueue, "N = 10");
            prod1.send((Message)textMessage);
            TextMessage received = (TextMessage)cons111.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            session11.close();
            MessageConsumer cons2 = session2.createConsumer((Destination)jmsQueue, "N = 10");
            received = (TextMessage)cons2.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            received.acknowledge();
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectorRoutingReDistributionOnLocalNoMatchConsumerCloseNeedsNewRemoteDemand() throws Exception {
        ((AddressSettings)this.server1.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        ((AddressSettings)this.server2.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        Connection conn1 = this.cf1.createConnection();
        Connection conn2 = this.cf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            Session session1 = conn1.createSession(false, 2);
            Session session1_n_10 = conn1.createSession(false, 2);
            Session session1_n_1 = conn1.createSession(false, 2);
            Session session2 = conn2.createSession(false, 2);
            Queue jmsQueue = session1.createQueue("myQueue");
            MessageProducer prod1 = session1.createProducer((Destination)jmsQueue);
            prod1.setDeliveryMode(2);
            TextMessage textMessage = session1.createTextMessage("m1");
            textMessage.setIntProperty("N", 10);
            MessageConsumer consumer2_n_10 = session2.createConsumer((Destination)jmsQueue, "N = 10");
            MessageConsumer consumer1_n_0 = session1.createConsumer((Destination)jmsQueue, "N = 0");
            MessageConsumer consumer1_n_1 = session1_n_1.createConsumer((Destination)jmsQueue, "N = 1");
            MessageConsumer consumer1_n_10 = session1_n_10.createConsumer((Destination)jmsQueue, "N = 10");
            this.waitForBindings(this.server1, "myQueue", false, 1, 1, 4000L);
            this.waitForBindings(this.server1, "myQueue", true, 1, 3, 4000L);
            prod1.send((Message)textMessage);
            TextMessage received = (TextMessage)consumer1_n_10.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            session1_n_10.close();
            SelectorRedistributionClusterTest.assertNull((Object)consumer2_n_10.receiveNoWait());
            session1_n_1.close();
            SelectorRedistributionClusterTest.assertNull((Object)consumer2_n_10.receiveNoWait());
            MessageConsumer consumer2_n_0 = session2.createConsumer((Destination)jmsQueue, "N = 0");
            received = (TextMessage)consumer2_n_10.receive(4000L);
            SelectorRedistributionClusterTest.assertNotNull((Object)received);
            SelectorRedistributionClusterTest.assertEquals((Object)"m1", (Object)received.getText());
            received.acknowledge();
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }
}

