/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.jms2client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Before;
import org.junit.Test;

public class BodyTest
extends JMSTestBase {
    private static final String Q_NAME = "SomeQueue";
    private Queue queue;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.jmsServer.createQueue(false, Q_NAME, null, true, new String[]{Q_NAME});
        this.queue = ActiveMQJMSClient.createQueue((String)Q_NAME);
    }

    @Test
    public void testBodyConversion() throws Throwable {
        try (Connection conn = this.cf.createConnection();){
            Session sess = conn.createSession();
            MessageProducer producer = sess.createProducer((Destination)this.queue);
            MessageConsumer cons = sess.createConsumer((Destination)this.queue);
            conn.start();
            BytesMessage bytesMessage = sess.createBytesMessage();
            producer.send((Message)bytesMessage);
            Message msg = cons.receiveNoWait();
            BodyTest.assertNotNull((Object)msg);
            try {
                msg.getBody(String.class);
                BodyTest.fail((String)"Exception expected");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
        }
    }
}

