/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server;

import jakarta.jms.Queue;
import jakarta.jms.Topic;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.unit.util.InVMNamingContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JMSServerDeployerTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(JMSServerDeployerTest.class);
    private JMSServerManager jmsServer;
    private Context context;
    private Configuration config;

    @Test
    public void testDeployUnusualQueueNames() throws Exception {
        this.doTestDeployQueuesWithUnusualNames("queue.with.dots.in.name", "/myqueue");
        this.doTestDeployQueuesWithUnusualNames("queue with spaces in name", "/myqueue2");
        this.doTestDeployQueuesWithUnusualNames("queue/with/slashes/in/name", "/myqueue3");
        this.doTestDeployQueuesWithUnusualNames("queue\\with\\backslashes\\in\\name", "/myqueue4");
        this.doTestDeployQueuesWithUnusualNames("queue with # chars and * chars in name", "/myqueue5");
    }

    @Test
    public void testDeployUnusualTopicNames() throws Exception {
        this.doTestDeployTopicsWithUnusualNames("topic.with.dots.in.name", "/mytopic");
        this.doTestDeployTopicsWithUnusualNames("topic with spaces in name", "/mytopic2");
        this.doTestDeployTopicsWithUnusualNames("topic/with/slashes/in/name", "/mytopic3");
        this.doTestDeployTopicsWithUnusualNames("topic\\with\\backslashes\\in\\name", "/mytopic4");
        this.doTestDeployTopicsWithUnusualNames("topic with # chars and * chars in name", "/mytopic5");
        this.doTestDeployTopicsWithUnusualNames("jms.topic.myTopic", "/mytopic6", "myTopic");
    }

    private void doTestDeployQueuesWithUnusualNames(String queueName, String jndiName) throws Exception {
        this.jmsServer.createQueue(false, queueName, null, false, new String[]{jndiName});
        Queue queue = (Queue)this.context.lookup(jndiName);
        Assert.assertNotNull((Object)queue);
        Assert.assertEquals((Object)queueName, (Object)queue.getQueueName());
    }

    private void doTestDeployTopicsWithUnusualNames(String topicName, String jndiName) throws Exception {
        this.jmsServer.createTopic(false, topicName, new String[]{jndiName});
        Topic topic = (Topic)this.context.lookup(jndiName);
        Assert.assertNotNull((Object)topic);
        Assert.assertEquals((Object)topicName, (Object)topic.getTopicName());
    }

    private void doTestDeployTopicsWithUnusualNames(String topicName, String jndiName, String jmsTopicName) throws Exception {
        this.jmsServer.createTopic(topicName, false, jmsTopicName, new String[]{jndiName});
        Topic topic = (Topic)this.context.lookup(jndiName);
        Assert.assertNotNull((Object)topic);
        Assert.assertEquals((Object)jmsTopicName, (Object)topic.getTopicName());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        DiscoveryGroupConfiguration dcg = new DiscoveryGroupConfiguration().setName("mygroup").setRefreshTimeout(5432L).setDiscoveryInitialWaitTimeout(5432L).setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(JMSServerDeployerTest.getUDPDiscoveryAddress()).setGroupPort(JMSServerDeployerTest.getUDPDiscoveryPort()).setLocalBindAddress("172.16.8.10"));
        this.config = this.createBasicConfig().addConnectorConfiguration("netty", new TransportConfiguration(NettyConnectorFactory.class.getName())).addDiscoveryGroupConfiguration("mygroup", dcg);
        ActiveMQServer server = this.createServer(false, this.config);
        this.jmsServer = new JMSServerManagerImpl(server);
        this.context = new InVMNamingContext();
        this.jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry(this.context));
        this.jmsServer.start();
    }
}

