/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server.management;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;

public class JMSUtil {
    public static Connection createConnection(String connectorFactory) throws JMSException {
        ActiveMQJMSConnectionFactory cf = (ActiveMQJMSConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactory)});
        cf.setBlockOnNonDurableSend(true);
        cf.setBlockOnDurableSend(true);
        cf.setBlockOnAcknowledge(true);
        return cf.createConnection();
    }

    public static ConnectionFactory createFactory(String connectorFactory, long connectionTTL, long clientFailureCheckPeriod) throws JMSException {
        ActiveMQJMSConnectionFactory cf = (ActiveMQJMSConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactory)});
        cf.setBlockOnNonDurableSend(true);
        cf.setBlockOnDurableSend(true);
        cf.setBlockOnAcknowledge(true);
        cf.setConnectionTTL(connectionTTL);
        cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        return cf;
    }

    static MessageConsumer createConsumer(Connection connection, Destination destination) throws JMSException {
        return JMSUtil.createConsumer(connection, destination, 1);
    }

    static MessageConsumer createConsumer(Connection connection, Destination destination, int ackMode) throws JMSException {
        Session s = connection.createSession(false, ackMode);
        return s.createConsumer(destination);
    }

    static TopicSubscriber createDurableSubscriber(Connection connection, Topic topic, String clientID, String subscriptionName) throws JMSException {
        return JMSUtil.createDurableSubscriber(connection, topic, clientID, subscriptionName, 1);
    }

    static TopicSubscriber createDurableSubscriber(Connection connection, Topic topic, String clientID, String subscriptionName, int ackMode) throws JMSException {
        connection.setClientID(clientID);
        Session s = connection.createSession(false, ackMode);
        return s.createDurableSubscriber(topic, subscriptionName);
    }

    public static String[] sendMessages(Destination destination, int messagesToSend) throws Exception {
        ActiveMQJMSConnectionFactory cf = (ActiveMQJMSConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName())});
        return JMSUtil.sendMessages((ConnectionFactory)cf, destination, messagesToSend);
    }

    public static String[] sendMessages(ConnectionFactory cf, Destination destination, int messagesToSend) throws Exception {
        String[] messageIDs = new String[messagesToSend];
        Connection conn = cf.createConnection();
        Session s = conn.createSession(false, 1);
        MessageProducer producer = s.createProducer(destination);
        for (int i = 0; i < messagesToSend; ++i) {
            TextMessage m = s.createTextMessage(RandomUtil.randomString());
            producer.send((Message)m);
            messageIDs[i] = m.getJMSMessageID();
        }
        conn.close();
        return messageIDs;
    }

    public static Message sendMessageWithProperty(Session session, Destination destination, String key, long value) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        Message message = session.createMessage();
        message.setLongProperty(key, value);
        producer.send(message);
        return message;
    }

    public static BytesMessage sendByteMessage(Session session, Destination destination, byte[] bytes) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(bytes);
        producer.send((Message)message);
        return message;
    }

    public static Message sendMessageWithProperty(Session session, Destination destination, String key, int value) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        Message message = session.createMessage();
        message.setIntProperty(key, value);
        producer.send(message);
        return message;
    }

    public static Message sendMessageWithProperty(Session session, Destination destination, String key, String value) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        Message message = session.createMessage();
        message.setStringProperty(key, value);
        producer.send(message);
        return message;
    }

    public static Message sendMessageWithReplyTo(Session session, Destination destination, String replyTo) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        Message message = session.createMessage();
        message.setJMSReplyTo((Destination)ActiveMQJMSClient.createQueue((String)replyTo));
        producer.send(message);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consumeMessages(int expected, Destination dest) throws JMSException {
        try (Connection connection = JMSUtil.createConnection(InVMConnectorFactory.class.getName());){
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer(dest);
            connection.start();
            Message m = null;
            for (int i = 0; i < expected; ++i) {
                m = consumer.receive(500L);
                Assert.assertNotNull((String)("expected to received " + expected + " messages, got only " + (i + 1)), (Object)m);
            }
            m = consumer.receiveNoWait();
            Assert.assertNull((String)("received one more message than expected (" + expected + ")"), (Object)m);
        }
    }

    public static void waitForServer(ActiveMQServer server) throws InterruptedException {
        long timetowait = System.currentTimeMillis() + 5000L;
        while (!server.isStarted()) {
            Thread.sleep(100L);
            if (server.isStarted()) break;
            if (System.currentTimeMillis() <= timetowait) continue;
            throw new IllegalStateException("server didn't start");
        }
    }

    public static void crash(ActiveMQServer server, ClientSession ... sessions) throws Exception {
        CountDownLatch latch = new CountDownLatch(sessions.length);
        for (ClientSession session : sessions) {
            class MyListener
            implements SessionFailureListener {
                final /* synthetic */ CountDownLatch val$latch;

                MyListener(CountDownLatch countDownLatch) {
                    this.val$latch = countDownLatch;
                }

                public void connectionFailed(ActiveMQException me, boolean failedOver) {
                    this.val$latch.countDown();
                }

                public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                    this.connectionFailed(me, failedOver);
                }

                public void beforeReconnect(ActiveMQException exception) {
                }
            }
            session.addFailureListener((SessionFailureListener)new MyListener(latch));
        }
        ClusterManager clusterManager = server.getClusterManager();
        clusterManager.clear();
        server.fail(true);
        boolean ok = latch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)ok);
    }

    public static ActiveMQConnection createConnectionAndWaitForTopology(ActiveMQConnectionFactory factory, int topologyMembers, int timeout) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(topologyMembers);
        ServerLocator locator = factory.getServerLocator();
        locator.addClusterTopologyListener((ClusterTopologyListener)new FailoverTestBase.LatchClusterTopologyListener(countDownLatch));
        ActiveMQConnection conn = (ActiveMQConnection)factory.createConnection();
        boolean ok = countDownLatch.await(timeout, TimeUnit.SECONDS);
        if (!ok) {
            throw new IllegalStateException("timed out waiting for topology");
        }
        return conn;
    }

    public static void waitForFailoverTopology(int timeToWait, ActiveMQServer backupServer, ActiveMQServer ... liveServers) throws Exception {
        long start = System.currentTimeMillis();
        int waitMillis = 2000;
        int sleepTime = 50;
        int nWaits = 0;
        while ((backupServer.getClusterManager() == null || backupServer.getClusterManager().getClusterConnections().size() != 1) && nWaits++ < 40) {
            Thread.sleep(50L);
        }
        Set ccs = backupServer.getClusterManager().getClusterConnections();
        if (ccs.size() != 1) {
            throw new IllegalStateException("You need a single cluster connection on this version of waitForTopology on ServiceTestBase");
        }
        boolean exists = false;
        for (ActiveMQServer liveServer : liveServers) {
            ClusterConnectionImpl clusterConnection = (ClusterConnectionImpl)ccs.iterator().next();
            Topology topology = clusterConnection.getTopology();
            TransportConfiguration nodeConnector = ((ClusterConnection)liveServer.getClusterManager().getClusterConnections().iterator().next()).getConnector();
            do {
                Collection members = topology.getMembers();
                for (TopologyMemberImpl member : members) {
                    if (member.getConnector().getA() == null || !((TransportConfiguration)member.getConnector().getA()).equals((Object)nodeConnector)) continue;
                    exists = true;
                    break;
                }
                if (exists) break;
                Thread.sleep(10L);
            } while (System.currentTimeMillis() - start < (long)timeToWait);
            if (exists) continue;
            String msg = "Timed out waiting for cluster topology of " + backupServer + " (received " + topology.getMembers().size() + ") topology = " + topology + ")";
            throw new Exception(msg);
        }
    }

    public static class JMXListener
    implements NotificationListener {
        private Notification notif;

        @Override
        public void handleNotification(Notification notification, Object handback) {
            this.notif = notification;
        }

        public Notification getNotification() {
            return this.notif;
        }
    }
}

