/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.util.ByteSequence;
import org.junit.Test;

public class MQTTOpenwireTest
extends MQTTTestSupport {
    protected static final int NUM_MESSAGES = 1;

    @Override
    public void configureBroker() throws Exception {
        super.configureBroker();
        WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
        wildcardConfiguration.setDelimiter('.');
        wildcardConfiguration.setSingleWord('*');
        wildcardConfiguration.setAnyWords('>');
        this.server.getConfiguration().setWildCardConfiguration(wildcardConfiguration);
    }

    @Override
    public void createJMSConnection() throws Exception {
        this.cf = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
    }

    @Test
    public void testWildcards() throws Exception {
        this.doTestSendJMSReceiveMQTT("foo.bar", "foo/+");
        this.doTestSendJMSReceiveMQTT("foo.bar", "foo/#");
        this.doTestSendJMSReceiveMQTT("foo.bar.har", "foo/#");
        this.doTestSendJMSReceiveMQTT("foo.bar.har", "foo/+/+");
        this.doTestSendMQTTReceiveJMS("foo/bah", "foo.*");
        this.doTestSendMQTTReceiveJMS("foo/bah", "foo.>");
        this.doTestSendMQTTReceiveJMS("foo/bah/hah", "foo.*.*");
        this.doTestSendMQTTReceiveJMS("foo/bah/har", "foo.>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestSendMQTTReceiveJMS(String mqttTopic, String jmsDestination) throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        ActiveMQConnection activeMQConnection = (ActiveMQConnection)this.cf.createConnection();
        try {
            activeMQConnection.setUseRetroactiveConsumer(true);
            activeMQConnection.start();
            Session s = activeMQConnection.createSession(false, 1);
            Topic jmsTopic = s.createTopic(jmsDestination);
            MessageConsumer consumer = s.createConsumer((Destination)jmsTopic);
            String RETAINED = "RETAINED";
            provider.publish(mqttTopic, "RETAINED".getBytes(), 1, true);
            ActiveMQMessage message = (ActiveMQMessage)consumer.receive(2000L);
            MQTTOpenwireTest.assertNotNull((String)("Should get retained message " + mqttTopic + "->" + jmsDestination), (Object)message);
            ByteSequence bs = message.getContent();
            MQTTOpenwireTest.assertEquals((Object)"RETAINED", (Object)new String(bs.data, bs.offset, bs.length));
            for (int i = 0; i < 1; ++i) {
                String payload = "Test Message: " + i;
                provider.publish(mqttTopic, payload.getBytes(), 1);
                message = (ActiveMQMessage)consumer.receive(1000L);
                MQTTOpenwireTest.assertNotNull((String)("Should get a message " + mqttTopic + "->" + jmsDestination), (Object)message);
                bs = message.getContent();
                MQTTOpenwireTest.assertEquals((Object)payload, (Object)new String(bs.data, bs.offset, bs.length));
            }
        }
        finally {
            activeMQConnection.close();
            provider.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestSendJMSReceiveMQTT(String jmsDestination, String mqttTopic) throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        ActiveMQConnection activeMQConnection = (ActiveMQConnection)this.cf.createConnection();
        try {
            activeMQConnection.setUseRetroactiveConsumer(true);
            activeMQConnection.start();
            Session s = activeMQConnection.createSession(false, 1);
            Topic jmsTopic = s.createTopic(jmsDestination);
            MessageProducer producer = s.createProducer((Destination)jmsTopic);
            String RETAINED = "RETAINED";
            provider.subscribe(mqttTopic, 0);
            TextMessage sendMessage = s.createTextMessage("RETAINED");
            sendMessage.setBooleanProperty("ActiveMQ.Retain", true);
            sendMessage.setIntProperty("ActiveMQ.MQTT.QoS", 0);
            producer.send((Message)sendMessage);
            byte[] message = provider.receive(2000);
            MQTTOpenwireTest.assertNotNull((String)("Should get retained message " + jmsDestination + "->" + mqttTopic), (Object)message);
            MQTTOpenwireTest.assertEquals((Object)"RETAINED", (Object)new String(message));
            for (int i = 0; i < 1; ++i) {
                String payload = "This is Test Message: " + i;
                sendMessage = s.createTextMessage(payload);
                producer.send((Message)sendMessage);
                message = provider.receive(1000);
                MQTTOpenwireTest.assertNotNull((String)("Should get a message " + jmsDestination + "->" + mqttTopic), (Object)message);
                MQTTOpenwireTest.assertEquals((Object)payload, (Object)new String(message));
            }
        }
        finally {
            activeMQConnection.close();
            provider.disconnect();
        }
    }
}

