/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.interop;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireInterceptor;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.TransportListener;
import org.junit.Before;
import org.junit.Test;

public class GeneralInteropTest
extends BasicOpenWireTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testReceivingFromCore() throws Exception {
        String text = "HelloWorld";
        this.sendTextMessageUsingCoreJms(this.queueName, "HelloWorld");
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)destination);
        TextMessage textMessage = (TextMessage)consumer.receive(5000L);
        GeneralInteropTest.assertEquals((Object)"HelloWorld", (Object)textMessage.getText());
        GeneralInteropTest.assertEquals((Object)destination, (Object)textMessage.getJMSDestination());
        this.sendMapMessageUsingCoreJms(this.queueName);
        MapMessage mapMessage = (MapMessage)consumer.receive(5000L);
        GeneralInteropTest.assertEquals((Object)destination, (Object)mapMessage.getJMSDestination());
        GeneralInteropTest.assertTrue((boolean)mapMessage.getBoolean("aboolean"));
        GeneralInteropTest.assertEquals((long)4L, (long)mapMessage.getByte("abyte"));
        byte[] bytes = mapMessage.getBytes("abytes");
        GeneralInteropTest.assertEquals((long)2L, (long)bytes.length);
        GeneralInteropTest.assertEquals((long)4L, (long)bytes[0]);
        GeneralInteropTest.assertEquals((long)5L, (long)bytes[1]);
        GeneralInteropTest.assertEquals((long)97L, (long)mapMessage.getChar("achar"));
        Double doubleVal = mapMessage.getDouble("adouble");
        GeneralInteropTest.assertTrue((boolean)doubleVal.equals(4.4));
        Float floatVal = Float.valueOf(mapMessage.getFloat("afloat"));
        GeneralInteropTest.assertTrue((boolean)floatVal.equals(Float.valueOf(4.5f)));
        GeneralInteropTest.assertEquals((long)40L, (long)mapMessage.getInt("aint"));
        GeneralInteropTest.assertEquals((long)80L, (long)mapMessage.getLong("along"));
        GeneralInteropTest.assertEquals((long)65L, (long)mapMessage.getShort("ashort"));
        GeneralInteropTest.assertEquals((Object)"hello", (Object)mapMessage.getString("astring"));
        SimpleSerializable obj = new SimpleSerializable();
        this.sendObjectMessageUsingCoreJms(this.queueName, obj);
        ObjectMessage objectMessage = (ObjectMessage)consumer.receive(5000L);
        SimpleSerializable data = (SimpleSerializable)objectMessage.getObject();
        GeneralInteropTest.assertEquals((Object)obj.objName, (Object)data.objName);
        GeneralInteropTest.assertEquals((long)obj.intVal, (long)data.intVal);
        GeneralInteropTest.assertEquals((long)obj.longVal, (long)data.longVal);
        this.sendStreamMessageUsingCoreJms(this.queueName);
        StreamMessage streamMessage = (StreamMessage)consumer.receive(5000L);
        GeneralInteropTest.assertEquals((Object)destination, (Object)streamMessage.getJMSDestination());
        GeneralInteropTest.assertTrue((boolean)streamMessage.readBoolean());
        GeneralInteropTest.assertEquals((long)2L, (long)streamMessage.readByte());
        byte[] streamBytes = new byte[2];
        streamMessage.readBytes(streamBytes);
        GeneralInteropTest.assertEquals((long)6L, (long)streamBytes[0]);
        GeneralInteropTest.assertEquals((long)7L, (long)streamBytes[1]);
        GeneralInteropTest.assertEquals((long)98L, (long)streamMessage.readChar());
        Double streamDouble = streamMessage.readDouble();
        GeneralInteropTest.assertTrue((boolean)streamDouble.equals(6.5));
        Float streamFloat = Float.valueOf(streamMessage.readFloat());
        GeneralInteropTest.assertTrue((boolean)streamFloat.equals(Float.valueOf(93.9f)));
        GeneralInteropTest.assertEquals((long)7657L, (long)streamMessage.readInt());
        GeneralInteropTest.assertEquals((long)239999L, (long)streamMessage.readLong());
        GeneralInteropTest.assertEquals((long)-31314L, (long)streamMessage.readShort());
        GeneralInteropTest.assertEquals((Object)"hello streammessage", (Object)streamMessage.readString());
        byte[] bytesData = "HelloWorld".getBytes(StandardCharsets.UTF_8);
        this.sendBytesMessageUsingCoreJms(this.queueName, bytesData);
        BytesMessage bytesMessage = (BytesMessage)consumer.receive(5000L);
        byte[] rawBytes = new byte[bytesData.length];
        bytesMessage.readBytes(rawBytes);
        for (int i = 0; i < bytesData.length; ++i) {
            GeneralInteropTest.assertEquals((String)("failed at " + i), (long)bytesData[i], (long)rawBytes[i]);
        }
        GeneralInteropTest.assertTrue((boolean)bytesMessage.readBoolean());
        GeneralInteropTest.assertEquals((long)99999L, (long)bytesMessage.readLong());
        GeneralInteropTest.assertEquals((long)104L, (long)bytesMessage.readChar());
        GeneralInteropTest.assertEquals((long)987L, (long)bytesMessage.readInt());
        GeneralInteropTest.assertEquals((long)1099L, (long)bytesMessage.readShort());
        GeneralInteropTest.assertEquals((Object)"hellobytes", (Object)bytesMessage.readUTF());
        this.sendMessageUsingCoreJms(this.queueName);
        Message genericMessage = consumer.receive(5000L);
        GeneralInteropTest.assertEquals((Object)destination, (Object)genericMessage.getJMSDestination());
        String value = genericMessage.getStringProperty("stringProperty");
        GeneralInteropTest.assertEquals((Object)"HelloMessage", (Object)value);
        GeneralInteropTest.assertFalse((boolean)genericMessage.getBooleanProperty("booleanProperty"));
        GeneralInteropTest.assertEquals((long)99999L, (long)genericMessage.getLongProperty("longProperty"));
        GeneralInteropTest.assertEquals((long)979L, (long)genericMessage.getIntProperty("intProperty"));
        GeneralInteropTest.assertEquals((long)1099L, (long)genericMessage.getShortProperty("shortProperty"));
        GeneralInteropTest.assertEquals((Object)"HelloMessage", (Object)genericMessage.getStringProperty("stringProperty"));
    }

    @Test
    public void testMutipleReceivingFromCore() throws Exception {
        String text = "HelloWorld";
        int num = 100;
        this.sendMultipleTextMessagesUsingCoreJms(this.queueName, "HelloWorld", 100);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)destination);
        for (int i = 0; i < 100; ++i) {
            TextMessage textMessage = (TextMessage)consumer.receive(5000L);
            GeneralInteropTest.assertEquals((Object)("HelloWorld" + i), (Object)textMessage.getText());
            GeneralInteropTest.assertEquals((Object)destination, (Object)textMessage.getJMSDestination());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailoverReceivingFromCore() throws Exception {
        String text = "HelloWorld";
        int prefetchSize = 10;
        SimpleString dla = new SimpleString("DLA");
        SimpleString dlq = new SimpleString("DLQ1");
        this.server.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(false)));
        this.server.getAddressSettingsRepository().addMatch(this.queueName, (Object)new AddressSettings().setDeadLetterAddress(dla));
        this.sendMultipleTextMessagesUsingCoreJms(this.queueName, "HelloWorld", 100);
        String urlString = "failover:(tcp://localhost:61616)?randomize=false&timeout=400&reconnectDelay=500&useExponentialBackOff=false&initialReconnectDelay=500&nested.wireFormat.maxInactivityDuration=500&nested.wireFormat.maxInactivityDurationInitalDelay=500&nested.soTimeout=500&nested.connectionTimeout=400&jms.connectResponseTimeout=400&jms.sendTimeout=400&jms.closeTimeout=400";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(urlString);
        connectionFactory.setSendAcksAsync(false);
        connectionFactory.setOptimizeAcknowledge(false);
        connectionFactory.getPrefetchPolicy().setAll(10);
        try (Connection connection = connectionFactory.createConnection();){
            connection.setClientID("test.consumer.queue." + this.queueName);
            connection.start();
            Message message = null;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(this.queueName);
            QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue." + this.queueName);
            QueueControl dlqControl = (QueueControl)this.server.getManagementService().getResource("queue." + dlq.toString());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            message = consumer.receive(5000L);
            GeneralInteropTest.assertNotNull((Object)message);
            GeneralInteropTest.assertTrue((boolean)(message instanceof TextMessage));
            GeneralInteropTest.assertEquals((Object)"HelloWorld0", (Object)((TextMessage)message).getText());
            message.acknowledge();
            Wait.assertEquals((Long)1L, () -> queueControl.getMessagesAcknowledged(), (long)3000L, (long)100L);
            Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
            message = consumer.receive(5000L);
            GeneralInteropTest.assertNotNull((Object)message);
            GeneralInteropTest.assertTrue((boolean)(message instanceof TextMessage));
            GeneralInteropTest.assertEquals((Object)"HelloWorld1", (Object)((TextMessage)message).getText());
            this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new OpenWireInterceptor(){

                public boolean intercept(Command packet, RemotingConnection connection) throws ActiveMQException {
                    if (packet.isMessageAck()) {
                        GeneralInteropTest.this.server.getRemotingService().removeIncomingInterceptor((BaseInterceptor)this);
                        return false;
                    }
                    return true;
                }
            });
            message.acknowledge();
            Wait.waitFor(() -> dlqControl.getMessageCount() == 1L && queueControl.getMessagesAcknowledged() == 1L || dlqControl.getMessageCount() == 0L && queueControl.getMessagesAcknowledged() == 2L, (long)3000L, (long)100L);
            Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
            message = consumer.receive(5000L);
            GeneralInteropTest.assertNotNull((Object)message);
            GeneralInteropTest.assertTrue((boolean)(message instanceof TextMessage));
            GeneralInteropTest.assertEquals((Object)"HelloWorld2", (Object)((TextMessage)message).getText());
            message.acknowledge();
            Wait.waitFor(() -> dlqControl.getMessageCount() == 1L && queueControl.getMessagesAcknowledged() == 2L || dlqControl.getMessageCount() == 0L && queueControl.getMessagesAcknowledged() == 3L, (long)3000L, (long)100L);
            Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)30000L, (long)100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailoverReceivingFromCoreWithAckAfterInterrupt() throws Exception {
        int prefetchSize = 10;
        String text = "HelloWorld";
        this.sendMultipleTextMessagesUsingCoreJms(this.queueName, "HelloWorld", 100);
        String urlString = "failover:(tcp://localhost:61616?wireFormat.MaxInactivityDuration=5000)";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(urlString);
        connectionFactory.setSendAcksAsync(false);
        connectionFactory.setOptimizeAcknowledge(false);
        connectionFactory.getPrefetchPolicy().setAll(10);
        try (Connection connection = connectionFactory.createConnection();){
            connection.setClientID("test.consumer.queue." + this.queueName);
            connection.start();
            Message message = null;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(this.queueName);
            QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue." + this.queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            message = consumer.receive(5000L);
            GeneralInteropTest.assertNotNull((Object)message);
            GeneralInteropTest.assertTrue((boolean)(message instanceof TextMessage));
            GeneralInteropTest.assertEquals((Object)"HelloWorld0", (Object)((TextMessage)message).getText());
            message.acknowledge();
            Wait.assertEquals((Long)1L, () -> queueControl.getMessagesAcknowledged(), (long)3000L, (long)100L);
            Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
            message = consumer.receive(5000L);
            GeneralInteropTest.assertNotNull((Object)message);
            GeneralInteropTest.assertTrue((boolean)(message instanceof TextMessage));
            GeneralInteropTest.assertEquals((Object)"HelloWorld1", (Object)((TextMessage)message).getText());
            final CountDownLatch interrupted = new CountDownLatch(1);
            ((ActiveMQConnection)connection).addTransportListener(new TransportListener(){

                public void onCommand(Object command) {
                }

                public void onException(IOException error) {
                }

                public void transportInterupted() {
                    interrupted.countDown();
                }

                public void transportResumed() {
                }
            });
            for (ServerSession serverSession : this.server.getSessions()) {
                if (!session.toString().contains(serverSession.getName())) continue;
                serverSession.getRemotingConnection().fail((ActiveMQException)new ActiveMQDisconnectedException());
            }
            GeneralInteropTest.assertTrue((boolean)interrupted.await(10L, TimeUnit.SECONDS));
            message.acknowledge();
            Wait.assertEquals((Long)1L, () -> queueControl.getMessagesAcknowledged(), (long)3000L, (long)100L);
            Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
            message = consumer.receive(5000L);
            GeneralInteropTest.assertNotNull((Object)message);
            GeneralInteropTest.assertTrue((boolean)(message instanceof TextMessage));
            GeneralInteropTest.assertEquals((Object)"HelloWorld1", (Object)((TextMessage)message).getText());
            message.acknowledge();
            Wait.assertEquals((Long)2L, () -> queueControl.getMessagesAcknowledged(), (long)3000L, (long)100L);
            Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)30000L, (long)100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveTwiceTheSameCoreMessage() throws Exception {
        String text = "HelloAgain";
        this.sendMultipleTextMessagesUsingCoreJms(this.queueName, "HelloAgain", 1);
        String urlString = "failover:(tcp://localhost:61616?wireFormat.MaxInactivityDuration=5000)";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(urlString);
        try (Connection connection = connectionFactory.createConnection();){
            connection.setClientID("clientId");
            connection.start();
            Message message = null;
            Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(this.queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            message = consumer.receive(4000L);
            GeneralInteropTest.assertNotNull((Object)message);
            String id1 = message.getJMSMessageID();
            consumer.close();
            consumer = session.createConsumer((Destination)queue);
            message = consumer.receive(4000L);
            GeneralInteropTest.assertNotNull((Object)message);
            String id2 = message.getJMSMessageID();
            GeneralInteropTest.assertEquals((Object)id1, (Object)id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMultipleTextMessagesUsingCoreJms(String queueName, String text, int num) throws Exception {
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            jmsConn.setClientID("PROD");
            Session session = jmsConn.createSession(false, 1);
            Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int i = 0; i < num; ++i) {
                TextMessage msg = session.createTextMessage(text + i);
                producer.send((Message)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageUsingCoreJms(String queueName) throws Exception {
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            Session session = jmsConn.createSession(false, 1);
            Message message = session.createMessage();
            message.setBooleanProperty("booleanProperty", false);
            message.setLongProperty("longProperty", 99999L);
            message.setByteProperty("byteProperty", (byte)5);
            message.setIntProperty("intProperty", 979);
            message.setShortProperty("shortProperty", (short)1099);
            message.setStringProperty("stringProperty", "HelloMessage");
            Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBytesMessageUsingCoreJms(String queueName, byte[] data) throws Exception {
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            Session session = jmsConn.createSession(false, 1);
            BytesMessage bytesMessage = session.createBytesMessage();
            bytesMessage.writeBytes(data);
            bytesMessage.writeBoolean(true);
            bytesMessage.writeLong(99999L);
            bytesMessage.writeChar('h');
            bytesMessage.writeInt(987);
            bytesMessage.writeShort((short)1099);
            bytesMessage.writeUTF("hellobytes");
            Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)bytesMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendObjectMessageUsingCoreJms(String queueName, Serializable object) throws Exception {
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            Session session = jmsConn.createSession(false, 1);
            ObjectMessage objectMessage = session.createObjectMessage(object);
            Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)objectMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStreamMessageUsingCoreJms(String queueName) throws Exception {
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            Session session = jmsConn.createSession(false, 1);
            StreamMessage msg = session.createStreamMessage();
            msg.writeBoolean(true);
            msg.writeByte((byte)2);
            msg.writeBytes(new byte[]{6, 7});
            msg.writeChar('b');
            msg.writeDouble(6.5);
            msg.writeFloat(93.9f);
            msg.writeInt(7657);
            msg.writeLong(239999L);
            msg.writeShort((short)-31314);
            msg.writeString("hello streammessage");
            Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMapMessageUsingCoreJms(String queueName) throws Exception {
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            Session session = jmsConn.createSession(false, 1);
            MapMessage mapMessage = session.createMapMessage();
            mapMessage.setBoolean("aboolean", true);
            mapMessage.setByte("abyte", (byte)4);
            mapMessage.setBytes("abytes", new byte[]{4, 5});
            mapMessage.setChar("achar", 'a');
            mapMessage.setDouble("adouble", 4.4);
            mapMessage.setFloat("afloat", 4.5f);
            mapMessage.setInt("aint", 40);
            mapMessage.setLong("along", 80L);
            mapMessage.setShort("ashort", (short)65);
            mapMessage.setString("astring", "hello");
            Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)mapMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTextMessageUsingCoreJms(String address, String text) throws Exception {
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            Session session = jmsConn.createSession(false, 1);
            TextMessage msg = session.createTextMessage(text);
            Queue queue = session.createQueue(address);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendingToCoreJms() throws Exception {
        String text = "HelloWorld";
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            jmsConn.start();
            Session session = jmsConn.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageConsumer coreConsumer = session.createConsumer((Destination)queue);
            this.sendTextMessageUsingOpenWire("HelloWorld");
            TextMessage txtMessage = (TextMessage)coreConsumer.receive(5000L);
            GeneralInteropTest.assertEquals((Object)"HelloWorld", (Object)txtMessage.getText());
            GeneralInteropTest.assertEquals((Object)txtMessage.getJMSDestination(), (Object)queue);
            this.sendMapMessageUsingOpenWire();
            MapMessage mapMessage = (MapMessage)coreConsumer.receive(5000L);
            GeneralInteropTest.assertEquals((Object)mapMessage.getJMSDestination(), (Object)queue);
            GeneralInteropTest.assertTrue((boolean)mapMessage.getBoolean("aboolean"));
            GeneralInteropTest.assertEquals((long)4L, (long)mapMessage.getByte("abyte"));
            byte[] bytes = mapMessage.getBytes("abytes");
            GeneralInteropTest.assertEquals((long)2L, (long)bytes.length);
            GeneralInteropTest.assertEquals((long)4L, (long)bytes[0]);
            GeneralInteropTest.assertEquals((long)5L, (long)bytes[1]);
            GeneralInteropTest.assertEquals((long)97L, (long)mapMessage.getChar("achar"));
            Double doubleVal = mapMessage.getDouble("adouble");
            GeneralInteropTest.assertTrue((boolean)doubleVal.equals(4.4));
            Float floatVal = Float.valueOf(mapMessage.getFloat("afloat"));
            GeneralInteropTest.assertTrue((boolean)floatVal.equals(Float.valueOf(4.5f)));
            GeneralInteropTest.assertEquals((long)40L, (long)mapMessage.getInt("aint"));
            GeneralInteropTest.assertEquals((long)80L, (long)mapMessage.getLong("along"));
            GeneralInteropTest.assertEquals((long)65L, (long)mapMessage.getShort("ashort"));
            GeneralInteropTest.assertEquals((Object)"hello", (Object)mapMessage.getString("astring"));
            SimpleSerializable obj = new SimpleSerializable();
            this.sendObjectMessageUsingOpenWire(obj);
            ObjectMessage objectMessage = (ObjectMessage)coreConsumer.receive(5000L);
            GeneralInteropTest.assertEquals((Object)objectMessage.getJMSDestination(), (Object)queue);
            SimpleSerializable data = (SimpleSerializable)objectMessage.getObject();
            GeneralInteropTest.assertEquals((Object)obj.objName, (Object)data.objName);
            GeneralInteropTest.assertEquals((long)obj.intVal, (long)data.intVal);
            GeneralInteropTest.assertEquals((long)obj.longVal, (long)data.longVal);
            this.sendStreamMessageUsingOpenWire(this.queueName);
            StreamMessage streamMessage = (StreamMessage)coreConsumer.receive(5000L);
            GeneralInteropTest.assertEquals((Object)streamMessage.getJMSDestination(), (Object)queue);
            GeneralInteropTest.assertTrue((boolean)streamMessage.readBoolean());
            GeneralInteropTest.assertEquals((long)2L, (long)streamMessage.readByte());
            byte[] streamBytes = new byte[2];
            streamMessage.readBytes(streamBytes);
            GeneralInteropTest.assertEquals((long)6L, (long)streamBytes[0]);
            GeneralInteropTest.assertEquals((long)7L, (long)streamBytes[1]);
            GeneralInteropTest.assertEquals((long)98L, (long)streamMessage.readChar());
            Double streamDouble = streamMessage.readDouble();
            GeneralInteropTest.assertTrue((boolean)streamDouble.equals(6.5));
            Float streamFloat = Float.valueOf(streamMessage.readFloat());
            GeneralInteropTest.assertTrue((boolean)streamFloat.equals(Float.valueOf(93.9f)));
            GeneralInteropTest.assertEquals((long)7657L, (long)streamMessage.readInt());
            GeneralInteropTest.assertEquals((long)239999L, (long)streamMessage.readLong());
            GeneralInteropTest.assertEquals((long)-31314L, (long)streamMessage.readShort());
            GeneralInteropTest.assertEquals((Object)"hello streammessage", (Object)streamMessage.readString());
            byte[] bytesData = "HelloWorld".getBytes(StandardCharsets.UTF_8);
            this.sendBytesMessageUsingOpenWire(bytesData);
            BytesMessage bytesMessage = (BytesMessage)coreConsumer.receive(5000L);
            GeneralInteropTest.assertEquals((Object)bytesMessage.getJMSDestination(), (Object)queue);
            byte[] rawBytes = new byte[bytesData.length];
            bytesMessage.readBytes(rawBytes);
            for (int i = 0; i < bytesData.length; ++i) {
                GeneralInteropTest.assertEquals((long)bytesData[i], (long)rawBytes[i]);
            }
            this.sendMessageUsingOpenWire(this.queueName);
            Message genericMessage = coreConsumer.receive(5000L);
            GeneralInteropTest.assertEquals((Object)genericMessage.getJMSDestination(), (Object)queue);
            String value = genericMessage.getStringProperty("stringProperty");
            GeneralInteropTest.assertEquals((Object)"HelloMessage", (Object)value);
            GeneralInteropTest.assertFalse((boolean)genericMessage.getBooleanProperty("booleanProperty"));
            GeneralInteropTest.assertEquals((long)99999L, (long)genericMessage.getLongProperty("longProperty"));
            GeneralInteropTest.assertEquals((long)979L, (long)genericMessage.getIntProperty("intProperty"));
            GeneralInteropTest.assertEquals((long)1099L, (long)genericMessage.getShortProperty("shortProperty"));
            GeneralInteropTest.assertEquals((Object)"HelloMessage", (Object)genericMessage.getStringProperty("stringProperty"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSendingToCoreJms() throws Exception {
        String text = "HelloWorld";
        int num = 100;
        try (Connection jmsConn = null;){
            jmsConn = this.coreCf.createConnection();
            jmsConn.start();
            Session session = jmsConn.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageConsumer coreConsumer = session.createConsumer((Destination)queue);
            this.sendMultipleTextMessagesUsingOpenWire("HelloWorld", 100);
            for (int i = 0; i < 100; ++i) {
                TextMessage txtMessage = (TextMessage)coreConsumer.receive(5000L);
                GeneralInteropTest.assertEquals((Object)txtMessage.getJMSDestination(), (Object)queue);
                GeneralInteropTest.assertEquals((Object)("HelloWorld" + i), (Object)txtMessage.getText());
            }
        }
    }

    private void sendMultipleTextMessagesUsingOpenWire(String text, int num) throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        for (int i = 0; i < num; ++i) {
            TextMessage textMessage = session.createTextMessage(text + i);
            producer.send((Message)textMessage);
        }
    }

    private void sendMessageUsingOpenWire(String queueName) throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        Message message = session.createMessage();
        message.setBooleanProperty("booleanProperty", false);
        message.setLongProperty("longProperty", 99999L);
        message.setByteProperty("byteProperty", (byte)5);
        message.setIntProperty("intProperty", 979);
        message.setShortProperty("shortProperty", (short)1099);
        message.setStringProperty("stringProperty", "HelloMessage");
        producer.send(message);
    }

    private void sendBytesMessageUsingOpenWire(byte[] bytesData) throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        BytesMessage bytesMessage = session.createBytesMessage();
        bytesMessage.writeBytes(bytesData);
        bytesMessage.writeBoolean(true);
        bytesMessage.writeLong(99999L);
        bytesMessage.writeChar('h');
        bytesMessage.writeInt(987);
        bytesMessage.writeShort((short)1099);
        bytesMessage.writeUTF("hellobytes");
        producer.send((Message)bytesMessage);
    }

    private void sendStreamMessageUsingOpenWire(String queueName) throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        StreamMessage streamMessage = session.createStreamMessage();
        streamMessage.writeBoolean(true);
        streamMessage.writeByte((byte)2);
        streamMessage.writeBytes(new byte[]{6, 7});
        streamMessage.writeChar('b');
        streamMessage.writeDouble(6.5);
        streamMessage.writeFloat(93.9f);
        streamMessage.writeInt(7657);
        streamMessage.writeLong(239999L);
        streamMessage.writeShort((short)-31314);
        streamMessage.writeString("hello streammessage");
        producer.send((Message)streamMessage);
    }

    private void sendObjectMessageUsingOpenWire(SimpleSerializable obj) throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        ObjectMessage objectMessage = session.createObjectMessage((Serializable)obj);
        producer.send((Message)objectMessage);
    }

    private void sendMapMessageUsingOpenWire() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        MapMessage mapMessage = session.createMapMessage();
        mapMessage.setBoolean("aboolean", true);
        mapMessage.setByte("abyte", (byte)4);
        mapMessage.setBytes("abytes", new byte[]{4, 5});
        mapMessage.setChar("achar", 'a');
        mapMessage.setDouble("adouble", 4.4);
        mapMessage.setFloat("afloat", 4.5f);
        mapMessage.setInt("aint", 40);
        mapMessage.setLong("along", 80L);
        mapMessage.setShort("ashort", (short)65);
        mapMessage.setString("astring", "hello");
        producer.send((Message)mapMessage);
    }

    private void sendTextMessageUsingOpenWire(String text) throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        ActiveMQMessageProducer producer = (ActiveMQMessageProducer)session.createProducer((Destination)destination);
        TextMessage textMessage = session.createTextMessage(text);
        producer.send((Message)textMessage);
    }

    private static class SimpleSerializable
    implements Serializable {
        private static final long serialVersionUID = -1034113865185130710L;
        public String objName = "simple-serializable";
        public int intVal = 9999;
        public long longVal = 88888888L;

        private SimpleSerializable() {
        }
    }
}

