/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedSecuritySetting;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.junit.Before;
import org.junit.Test;

public class RolesConfigurationStorageTest
extends StorageManagerTestBase {
    private Map<SimpleString, PersistedSecuritySetting> mapExpectedSets;

    public RolesConfigurationStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mapExpectedSets = new HashMap<SimpleString, PersistedSecuritySetting>();
    }

    protected void addSetting(PersistedSecuritySetting setting) throws Exception {
        this.mapExpectedSets.put(setting.getAddressMatch(), setting);
        this.journal.storeSecuritySetting(setting);
    }

    @Test
    public void testStoreSecuritySettings() throws Exception {
        this.createStorage();
        this.addSetting(new PersistedSecuritySetting("a#", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1"));
        this.addSetting(new PersistedSecuritySetting("a2", "a1", null, "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1"));
        this.journal.stop();
        this.checkSettings();
        this.createStorage();
        this.checkSettings();
        this.addSetting(new PersistedSecuritySetting("a2", "a1", null, "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1"));
        this.addSetting(new PersistedSecuritySetting("a3", "a1", null, "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1"));
        this.checkSettings();
        this.journal.stop();
        this.createStorage();
        this.checkSettings();
        this.journal.stop();
        this.journal = null;
    }

    @Test
    public void testStoreSecuritySettings2() throws Exception {
        this.createStorage();
        this.checkSettings();
        this.journal.stop();
        this.createStorage();
        this.checkSettings();
        this.addSetting(new PersistedSecuritySetting("a#", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1", "a1"));
        this.journal.stop();
        this.createStorage();
        this.checkSettings();
        this.journal.stop();
        this.createStorage();
        this.checkSettings();
    }

    private void checkSettings() throws Exception {
        List listSetting = this.journal.recoverSecuritySettings();
        RolesConfigurationStorageTest.assertEquals((long)this.mapExpectedSets.size(), (long)listSetting.size());
        for (PersistedSecuritySetting el : listSetting) {
            PersistedSecuritySetting el2 = this.mapExpectedSets.get(el.getAddressMatch());
            RolesConfigurationStorageTest.assertEquals((Object)el, (Object)el2);
        }
    }
}

