/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.integration.plugin.MethodCalledVerifier;
import org.junit.Test;

public class OpenwirePluginTest
extends BasicOpenWireTest {
    private final Map<String, AtomicInteger> methodCalls = new ConcurrentHashMap<String, AtomicInteger>();
    private final MethodCalledVerifier verifier = new MethodCalledVerifier(this.methodCalls);

    protected ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, long maxAddressSize, Map<String, AddressSettings> settings) {
        ActiveMQServer server = super.createServer(realFiles, configuration, pageSize, maxAddressSize, settings);
        server.registerBrokerPlugin((ActiveMQServerBasePlugin)this.verifier);
        server.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerPlugin(){

            public void afterCreateConnection(RemotingConnection connection) throws ActiveMQException {
                try {
                    connection.getClientID();
                }
                catch (Exception e) {
                    throw new ActiveMQException(e.getMessage());
                }
            }
        });
        configuration.getAddressesSettings().put("autoCreated", new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteQueues(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)));
        return server;
    }

    @Test(timeout=10000L)
    public void testAckedMessageAreConsumed() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.queueName);
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        OpenwirePluginTest.assertNotNull((Object)msg);
        session.close();
        session = this.connection.createSession(false, 1);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        OpenwirePluginTest.assertNull((Object)msg);
        session.close();
        this.connection.close();
        this.verifier.validatePluginMethodsEquals(0, "messageExpired", "beforeDeployBridge", "afterDeployBridge", "beforeSessionMetadataAdded", "afterSessionMetadataAdded");
        this.verifier.validatePluginMethodsAtLeast(1, "afterCreateConnection", "afterDestroyConnection", "beforeCreateSession", "afterCreateSession", "beforeCloseSession", "afterCloseSession", "beforeCreateConsumer", "afterCreateConsumer", "beforeCloseConsumer", "afterCloseConsumer", "beforeCreateQueue", "afterCreateQueue", "messageAcknowledged", "beforeSend", "afterSend", "beforeMessageRoute", "afterMessageRoute", "beforeDeliver", "afterDeliver", "beforeAddAddress", "afterAddAddress", "beforeAddBinding", "afterAddBinding", "beforeRemoveBinding", "afterRemoveBinding");
    }

    @Test(timeout=10000L)
    public void testAutoCreatedQueue() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("autoCreated");
        session.close();
        session = this.connection.createSession(false, 1);
        session.createConsumer((Destination)queue);
        session.close();
        this.connection.close();
        this.verifier.validatePluginMethodsAtLeast(2, "beforeAddAddress", "afterAddAddress", "beforeRemoveAddress", "afterRemoveAddress");
    }
}

