/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFile;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SharedNothingReplicationFlowControlTest
extends ActiveMQTestBase {
    ExecutorService sendMessageExecutor;
    private static final Logger logger = Logger.getLogger(SharedNothingReplicationFlowControlTest.class);
    @Rule
    public TemporaryFolder brokersFolder = new TemporaryFolder();

    @Before
    public void setupExecutor() {
        this.sendMessageExecutor = Executors.newCachedThreadPool();
    }

    @After
    public void teardownExecutor() {
        this.sendMessageExecutor.shutdownNow();
    }

    @Test
    public void testReplicationIfFlowControlled() throws Exception {
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.start();
        Wait.waitFor(() -> liveServer.isStarted());
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"tcp://localhost:61616");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession sess = csf.createSession();
        sess.createQueue(new QueueConfiguration("flowcontrol").setRoutingType(RoutingType.ANYCAST));
        sess.close();
        int j = 100;
        CountDownLatch allMessageSent = new CountDownLatch(100);
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.start();
        Wait.waitFor(() -> backupServer.isStarted());
        Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync(), (long)30000L);
        TestInterceptor interceptor = new TestInterceptor(30000L);
        backupServer.getClusterManager().getClusterController().addIncomingInterceptorForReplication((Interceptor)interceptor);
        byte[] body = new byte[32768];
        for (int i = 0; i < 100; ++i) {
            this.sendMessageExecutor.execute(() -> {
                try {
                    ClientSession session = csf.createSession(true, true);
                    ClientProducer producer = session.createProducer("flowcontrol");
                    ClientMessage message = session.createMessage(true);
                    message.writeBodyBufferBytes(body);
                    logger.infof("try to send a message after replicated", new Object[0]);
                    producer.send((Message)message);
                    logger.info((Object)"send message done");
                    producer.close();
                    session.close();
                    allMessageSent.countDown();
                }
                catch (ActiveMQException e) {
                    logger.error((Object)"send message", (Throwable)e);
                }
            });
        }
        Assert.assertTrue((String)"all message sent", (boolean)allMessageSent.await(30L, TimeUnit.SECONDS));
        interceptor.setSleepTime(0L);
        csf.close();
        locator.close();
        Assert.assertTrue((String)"Waiting for replica sync timeout", (boolean)Wait.waitFor(() -> ((ActiveMQServer)liveServer).isReplicaSync(), (long)30000L));
        backupServer.stop(true);
        liveServer.stop(true);
        MappedSequentialFileFactory fileFactory = new MappedSequentialFileFactory(liveConfiguration.getJournalLocation(), liveConfiguration.getJournalFileSize(), false, liveConfiguration.getJournalBufferSize_NIO(), liveConfiguration.getJournalBufferTimeout_NIO(), null);
        JournalImpl liveMessageJournal = new JournalImpl(liveConfiguration.getJournalFileSize(), liveConfiguration.getJournalMinFiles(), liveConfiguration.getJournalPoolFiles(), liveConfiguration.getJournalCompactMinFiles(), liveConfiguration.getJournalCompactPercentage(), (SequentialFileFactory)fileFactory, "activemq-data", "amq", fileFactory.getMaxIO());
        liveMessageJournal.start();
        final AtomicInteger liveJournalCounter = new AtomicInteger();
        liveMessageJournal.load((LoaderCallback)new AddRecordLoaderCallback(){

            public void addRecord(RecordInfo info) {
                if (info.userRecordType != 45) {
                    // empty if block
                }
                logger.infof("got live message %d %d", (Object)info.id, (Object)info.userRecordType);
                liveJournalCounter.incrementAndGet();
            }
        });
        File backupJournalDir = this.brokersFolder.getRoot().toPath().resolve("backup").resolve("data").resolve("journal").toFile();
        fileFactory = new MappedSequentialFileFactory(backupConfiguration.getJournalLocation(), backupConfiguration.getJournalFileSize(), false, backupConfiguration.getJournalBufferSize_NIO(), backupConfiguration.getJournalBufferTimeout_NIO(), null);
        JournalImpl backupMessageJournal = new JournalImpl(backupConfiguration.getJournalFileSize(), backupConfiguration.getJournalMinFiles(), backupConfiguration.getJournalPoolFiles(), backupConfiguration.getJournalCompactMinFiles(), backupConfiguration.getJournalCompactPercentage(), (SequentialFileFactory)fileFactory, "activemq-data", "amq", fileFactory.getMaxIO());
        backupMessageJournal.start();
        final AtomicInteger replicationCounter = new AtomicInteger();
        backupMessageJournal.load((LoaderCallback)new AddRecordLoaderCallback(){

            public void addRecord(RecordInfo info) {
                if (info.userRecordType != 45) {
                    // empty if block
                }
                logger.infof("replicated message %d", (Object)info.id);
                replicationCounter.incrementAndGet();
            }
        });
        logger.infof("expected %d messages, live=%d, backup=%d", (Object)100, (Object)liveJournalCounter.get(), (Object)replicationCounter.get());
        Assert.assertEquals((String)"Live lost journal record", (long)100L, (long)liveJournalCounter.get());
        Assert.assertEquals((String)"Backup did not replicated all journal", (long)100L, (long)replicationCounter.get());
    }

    @Test
    public void testSendPages() throws Exception {
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.start();
        Wait.waitFor(() -> liveServer.isStarted());
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"tcp://localhost:61616");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        locator.setBlockOnDurableSend(false);
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession sess = csf.createSession();
        sess.createQueue(new QueueConfiguration("flowcontrol").setRoutingType(RoutingType.ANYCAST));
        PagingStore store = liveServer.getPagingManager().getPageStore(SimpleString.toSimpleString((String)"flowcontrol"));
        store.startPaging();
        ClientProducer prod = sess.createProducer("flowcontrol");
        for (int i = 0; i < 100; ++i) {
            prod.send((Message)sess.createMessage(true));
            if (i % 10 != 0) continue;
            sess.commit();
            store.forceAnotherPage();
        }
        sess.close();
        TestableSequentialFile.openFiles.clear();
        Configuration backupConfiguration = this.createBackupConfiguration().setNetworkCheckURLList(null);
        ActiveMQServerImpl backupServer = new ActiveMQServerImpl(backupConfiguration, ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), new SecurityConfiguration())){

            public PagingManager createPagingManager() throws Exception {
                PagingManagerImpl manager = (PagingManagerImpl)super.createPagingManager();
                PagingStoreFactoryNIO originalPageStore = (PagingStoreFactoryNIO)manager.getPagingStoreFactory();
                manager.replacePageStoreFactory((PagingStoreFactory)new PageStoreFactoryTestable(originalPageStore));
                return manager;
            }
        };
        this.addServer((ActiveMQServer)backupServer).start();
        Wait.waitFor(() -> SharedNothingReplicationFlowControlTest.lambda$testSendPages$4((ActiveMQServer)backupServer));
        Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync(), (long)30000L);
        if (!Wait.waitFor(() -> TestableSequentialFile.openFiles.size() == 0, (long)5000L)) {
            StringWriter writer = new StringWriter();
            PrintWriter print = new PrintWriter(writer);
            for (TestableSequentialFile fileOpen : TestableSequentialFile.openFiles.keySet()) {
                print.println("File still open ::" + (Object)((Object)fileOpen));
            }
            Assert.fail((String)writer.toString());
        }
    }

    protected HAPolicyConfiguration createReplicationLiveConfiguration() {
        return new ReplicatedPolicyConfiguration().setVoteOnReplicationFailure(false).setCheckForLiveServer(false);
    }

    private Configuration createLiveConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::live");
        File liveDir = this.brokersFolder.newFolder("live");
        conf.setBrokerInstance(liveDir);
        conf.addAcceptorConfiguration("live", "tcp://localhost:61616?writeBufferHighWaterMark=2048&writeBufferLowWaterMark=2048");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        conf.setHAPolicyConfiguration(this.createReplicationLiveConfiguration());
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("live");
        ccconf.setCallTimeout(4000L);
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        return new ReplicaPolicyConfiguration().setClusterName("cluster");
    }

    private Configuration createBackupConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::backup");
        File backupDir = this.brokersFolder.newFolder("backup");
        conf.setBrokerInstance(backupDir);
        conf.setHAPolicyConfiguration(this.createReplicationBackupConfiguration());
        conf.addAcceptorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("live");
        ccconf.setName("cluster");
        ccconf.setConnectorName("backup");
        conf.addClusterConfiguration(ccconf);
        conf.setNetworkCheckPeriod(1000000L).setNetworkCheckURLList("http://localhost:28787").setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    private static /* synthetic */ boolean lambda$testSendPages$4(ActiveMQServer backupServer) throws Exception {
        return backupServer.isStarted();
    }

    public static final class TestInterceptor
    implements Interceptor {
        private long sleepTime;

        public TestInterceptor(long sleepTime) {
            this.sleepTime = sleepTime;
        }

        public void setSleepTime(long sleepTime) {
            this.sleepTime = sleepTime;
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            try {
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() < startTime + this.sleepTime) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    abstract class AddRecordLoaderCallback
    implements LoaderCallback {
        AddRecordLoaderCallback() {
        }

        public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
        }

        public void deleteRecord(long id) {
        }

        public void updateRecord(RecordInfo info) {
        }

        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        }
    }

    public static class TestableSequentialFile
    extends NIOSequentialFile {
        static Map<TestableSequentialFile, Exception> openFiles = new ConcurrentHashMap<TestableSequentialFile, Exception>();

        public boolean equals(Object obj) {
            TestableSequentialFile other = (TestableSequentialFile)((Object)obj);
            return other.getFile().equals(this.getFile());
        }

        public String toString() {
            return "TestableSequentialFile::" + this.getFile().toString();
        }

        public int hashCode() {
            return this.getFile().hashCode();
        }

        public TestableSequentialFile(SequentialFileFactory factory, File directory, String file, int maxIO, Executor writerExecutor) {
            super(factory, directory, file, maxIO, writerExecutor);
        }

        public void open(int maxIO, boolean useExecutor) throws IOException {
            super.open(maxIO, useExecutor);
            openFiles.put(this, new Exception("open"));
        }

        public synchronized void close(boolean waitSync, boolean block) throws IOException, InterruptedException, ActiveMQException {
            super.close(waitSync, block);
            openFiles.remove((Object)this);
        }
    }

    public static class TestableNIOFactory
    extends NIOSequentialFileFactory {
        public TestableNIOFactory(File journalDir, boolean buffered, IOCriticalErrorListener listener, int maxIO) {
            super(journalDir, buffered, listener, maxIO);
        }

        public SequentialFile createSequentialFile(String fileName) {
            return new TestableSequentialFile((SequentialFileFactory)this, this.journalDir, fileName, this.maxIO, this.writeExecutor);
        }
    }

    private static class PageStoreFactoryTestable
    extends PagingStoreFactoryNIO {
        PageStoreFactoryTestable(StorageManager storageManager, File directory, long syncTimeout, ScheduledExecutorService scheduledExecutor, ExecutorFactory executorFactory, boolean syncNonTransactional, IOCriticalErrorListener critialErrorListener) {
            super(storageManager, directory, syncTimeout, scheduledExecutor, executorFactory, syncNonTransactional, critialErrorListener);
        }

        PageStoreFactoryTestable(PagingStoreFactoryNIO other) {
            this(other.getStorageManager(), other.getDirectory(), other.getSyncTimeout(), other.getScheduledExecutor(), other.getExecutorFactory(), other.isSyncNonTransactional(), other.getCritialErrorListener());
        }

        protected SequentialFileFactory newFileFactory(String directoryName) {
            return new TestableNIOFactory(new File(this.getDirectory(), directoryName), false, this.getCritialErrorListener(), 1);
        }
    }
}

