/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SharedNothingReplicationTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(SharedNothingReplicationTest.class);
    @Rule
    public TemporaryFolder brokersFolder = new TemporaryFolder();
    private SlowMessagePersister slowMessagePersister;
    ExecutorService sendMessageExecutor;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.sendMessageExecutor = Executors.newSingleThreadExecutor();
        CoreMessagePersister.registerPersister((CoreMessagePersister)SlowMessagePersister._getInstance());
    }

    @After
    public void tearDown() throws Exception {
        CoreMessagePersister.resetPersister();
        this.sendMessageExecutor.shutdownNow();
        super.tearDown();
    }

    @Test
    public void testReplicateFromSlowLive() throws Exception {
        int i;
        Configuration liveConfiguration = this.createLiveConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        liveServer.start();
        Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        final CountDownLatch replicated = new CountDownLatch(1);
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"tcp://localhost:61616");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        locator.addClusterTopologyListener(new ClusterTopologyListener(){

            public void nodeUP(TopologyMember member, boolean last) {
                logger.debugf("nodeUP fired last=%s, live=%s, backup=%s", (Object)last, (Object)member.getLive(), (Object)member.getBackup());
                if (member.getBackup() != null) {
                    replicated.countDown();
                }
            }

            public void nodeDown(long eventUID, String nodeID) {
            }
        });
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession sess = csf.createSession();
        sess.createQueue(new QueueConfiguration("slow").setRoutingType(RoutingType.ANYCAST));
        sess.close();
        int j = 50;
        CountDownLatch allMessageSent = new CountDownLatch(50);
        for (i = 0; i < 5; ++i) {
            this.sendMessageExecutor.execute(() -> {
                try {
                    ClientSession session = csf.createSession(true, true);
                    ClientProducer producer = session.createProducer("slow");
                    ClientMessage message = session.createMessage(true);
                    message.putLongProperty("delay", 500L);
                    logger.debugf("try to send a message before replicated", new Object[0]);
                    producer.send((Message)message);
                    logger.debugf("send message done", new Object[0]);
                    producer.close();
                    session.close();
                    allMessageSent.countDown();
                }
                catch (ActiveMQException e) {
                    logger.error((Object)"send message", (Throwable)e);
                }
            });
        }
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.start();
        Wait.waitFor(() -> backupServer.isStarted());
        Assert.assertTrue((String)"can not replicate in 30 seconds", (boolean)replicated.await(30L, TimeUnit.SECONDS));
        while (i < 50) {
            this.sendMessageExecutor.execute(() -> {
                try {
                    ClientSession session = csf.createSession(true, true);
                    ClientProducer producer = session.createProducer("slow");
                    ClientMessage message = session.createMessage(true);
                    message.putLongProperty("delay", 0L);
                    logger.debugf("try to send a message after replicated", new Object[0]);
                    producer.send((Message)message);
                    logger.debugf("send message done", new Object[0]);
                    producer.close();
                    session.close();
                    allMessageSent.countDown();
                }
                catch (ActiveMQException e) {
                    logger.error((Object)"send message", (Throwable)e);
                }
            });
            ++i;
        }
        Assert.assertTrue((String)"all message sent", (boolean)allMessageSent.await(30L, TimeUnit.SECONDS));
        csf.close();
        locator.close();
        backupServer.stop(true);
        liveServer.stop(true);
        File liveJournalDir = this.brokersFolder.getRoot().toPath().resolve("live").resolve("data").resolve("journal").toFile();
        MappedSequentialFileFactory fileFactory = new MappedSequentialFileFactory(liveConfiguration.getJournalLocation(), liveConfiguration.getJournalFileSize(), false, liveConfiguration.getJournalBufferSize_NIO(), liveConfiguration.getJournalBufferTimeout_NIO(), null);
        JournalImpl liveMessageJournal = new JournalImpl(liveConfiguration.getJournalFileSize(), liveConfiguration.getJournalMinFiles(), liveConfiguration.getJournalPoolFiles(), liveConfiguration.getJournalCompactMinFiles(), liveConfiguration.getJournalCompactPercentage(), (SequentialFileFactory)fileFactory, "activemq-data", "amq", fileFactory.getMaxIO());
        liveMessageJournal.start();
        final AtomicInteger liveJournalCounter = new AtomicInteger();
        liveMessageJournal.load((LoaderCallback)new AddRecordLoaderCallback(){

            public void addRecord(RecordInfo info) {
                if (info.userRecordType != 45) {
                    // empty if block
                }
                logger.debugf("got live message %d", info.id);
                liveJournalCounter.incrementAndGet();
            }
        });
        File backupJournalDir = this.brokersFolder.getRoot().toPath().resolve("backup").resolve("data").resolve("journal").toFile();
        fileFactory = new MappedSequentialFileFactory(backupConfiguration.getJournalLocation(), backupConfiguration.getJournalFileSize(), false, backupConfiguration.getJournalBufferSize_NIO(), backupConfiguration.getJournalBufferTimeout_NIO(), null);
        JournalImpl backupMessageJournal = new JournalImpl(backupConfiguration.getJournalFileSize(), backupConfiguration.getJournalMinFiles(), backupConfiguration.getJournalPoolFiles(), backupConfiguration.getJournalCompactMinFiles(), backupConfiguration.getJournalCompactPercentage(), (SequentialFileFactory)fileFactory, "activemq-data", "amq", fileFactory.getMaxIO());
        backupMessageJournal.start();
        final AtomicInteger replicationCounter = new AtomicInteger();
        backupMessageJournal.load((LoaderCallback)new AddRecordLoaderCallback(){

            public void addRecord(RecordInfo info) {
                if (info.userRecordType != 45) {
                    // empty if block
                }
                logger.debugf("replicated message %d", info.id);
                replicationCounter.incrementAndGet();
            }
        });
        logger.debugf("expected %d messages, live=%d, backup=%d", 50, liveJournalCounter.get(), replicationCounter.get());
        Assert.assertEquals((String)"Live lost journal record", (long)50L, (long)liveJournalCounter.get());
        Assert.assertEquals((String)"Backup did not replicated all journal", (long)50L, (long)replicationCounter.get());
        Assert.assertTrue((String)"The test is not valid, slow persister stopped being used", (boolean)SlowMessagePersister._getInstance().used);
    }

    protected HAPolicyConfiguration createReplicationLiveConfiguration() {
        return new ReplicatedPolicyConfiguration().setVoteOnReplicationFailure(false).setCheckForLiveServer(false);
    }

    protected Configuration createLiveConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::live");
        File liveDir = this.brokersFolder.newFolder("live");
        conf.setBrokerInstance(liveDir);
        conf.addAcceptorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        conf.setHAPolicyConfiguration(this.createReplicationLiveConfiguration());
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("live");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        return new ReplicaPolicyConfiguration().setClusterName("cluster");
    }

    protected Configuration createBackupConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::backup");
        File backupDir = this.brokersFolder.newFolder("backup");
        conf.setBrokerInstance(backupDir);
        conf.setHAPolicyConfiguration(this.createReplicationBackupConfiguration());
        conf.addAcceptorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("live");
        ccconf.setName("cluster");
        ccconf.setConnectorName("backup");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    abstract class AddRecordLoaderCallback
    implements LoaderCallback {
        AddRecordLoaderCallback() {
        }

        public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
        }

        public void deleteRecord(long id) {
        }

        public void updateRecord(RecordInfo info) {
        }

        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        }
    }

    static class SlowMessagePersister
    extends CoreMessagePersister
    implements Persister<Message> {
        boolean used = false;
        private static final Logger logger = Logger.getLogger(SlowMessagePersister.class);
        static SlowMessagePersister theInstance;
        private final CoreMessagePersister persister = CoreMessagePersister.getInstance();

        private SlowMessagePersister() {
        }

        static SlowMessagePersister _getInstance() {
            if (theInstance == null) {
                theInstance = new SlowMessagePersister();
            }
            return theInstance;
        }

        public byte getID() {
            return this.persister.getID();
        }

        public int getEncodeSize(Message record) {
            return this.persister.getEncodeSize(record);
        }

        public void encode(ActiveMQBuffer buffer, Message record) {
            this.used = true;
            try {
                Long delay = record.getLongProperty("delay");
                if (delay == null || delay <= 0L) {
                    logger.debugf("encode message %d, caller=%s", record.getMessageID(), (Object)Thread.currentThread().getName());
                } else {
                    logger.debugf("sleep %d ms before encode message %d, caller=%s", delay.longValue(), record.getMessageID(), (Object)Thread.currentThread().getName());
                    Thread.sleep(delay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.persister.encode(buffer, record);
        }

        public Message decode(ActiveMQBuffer buffer, Message message, CoreMessageObjectPools pool) {
            return this.persister.decode(buffer, message, pool);
        }
    }
}

